EE.norm <- function(pobl,fun,n,k,tolerance,
                    maxiter,n_gen,...){
  error <- 1e10
  pobl <- as.data.frame(pobl)
  mu <- apply(pobl, 2, mean)
  std <- apply(pobl, 2, sd)
  P <- as.data.frame(mapply(rnorm, n = n, mean = mu, sd = std))
  Y <- apply(P, 1, fun,...)
  G <- 0
  historical <- c(min(Y))
  n_gen2 <- 1
  n_gen <- n_gen + 1
  while (G < k & n_gen < maxiter) {
    Q <- as.data.frame(mapply(rnorm, n = n, mean = mu, sd = std))
    Z <- apply(Q, 1, fun,...)
    historical <- c(historical,min(Z))
    P <- rbind(P,Q)
    error <- comparison(x = Y, y = c(Y,Z))
    Y <- c(Y,Z)
    n_gen <- n_gen + 1
    n_gen2 <- n_gen2 + 1
    if(error > tolerance){
      G <- 0
    }else{
      G <- G + 1
    }
  }
  best_par <- P[order(Y)[1:n],]
  return(list(par = best_par, Y = Y,n_gen = n_gen,
              par_historical = P,
              historical = historical,n_gen2 = n_gen2))
}


