% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{Apply.function}
\alias{Apply.function}
\title{Apply Functions Over Array Margins, using custom vectorization (possibly using parallel)}
\usage{
Apply.function(
  FUN,
  X,
  MARGIN = 1,
  .combine = c,
  .lapply = parallel::mclapply,
  ...
)
}
\arguments{
\item{FUN}{function to apply on X}

\item{X}{array of input values for FUN}

\item{MARGIN}{1 indicates to apply on rows (default), 2 on columns}

\item{.combine}{how to combine results (default using c(.))}

\item{.lapply}{how to vectorize FUN call (default is parallel::mclapply)}

\item{...}{optional arguments to FUN.}
}
\value{
array of values taken by FUN on each row/column of X
}
\description{
Emulate parallel apply on a function, from mclapply. Returns a vector or array or list of values obtained by applying a function to margins of an array or matrix.
}
\examples{
X = matrix(runif(10),ncol=2);
  rowSums(X) == apply(X,1,sum)
  apply(X,1,sum) == Apply.function(sum,X)

X = matrix(runif(10),ncol=1)
  rowSums(X) == apply(X,1,sum)
  apply(X,1,sum) == Apply.function(sum,X)

X = matrix(runif(10),ncol=2)
f = function(X) X[1]/X[2]
apply(X,1,f) == Apply.function(f,X)
}
