% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSSP.R, R/DSSP_fun.R
\name{DSSP}
\alias{DSSP}
\title{DSSP}
\usage{
DSSP(formula, data, N, pars, log_prior = function(x) -x, coords = NULL)
}
\arguments{
\item{formula}{a two sided linear formula with the response on left and the covariates on the right.}

\item{data}{a \code{data.frame} or \code{sp::SpatialPointsDataFrame} containing the response variable, covariates and coordinates.}

\item{N}{is the number of random samples to be drawn from the joint posterior for eta, delta, and nu.}

\item{pars}{a vector of the prior shape and rate parameters for the inverse-gamma
prior distribution of delta, the variance parameter for the Gaussian likelihood.}

\item{log_prior}{a function evaluating the log of the prior density of eta. Default to be \code{function(x) -x}.}

\item{coords}{spatial coordinates passed as the \code{value} argument to \code{sp::coordinates()}.}
}
\value{
A list containing N samples of nu, eta, delta, and the original data X and Y.
}
\description{
This function samples from the log-posterior of all parameters in the model and returns a list
   object containing the samples. It performs a few compatibility checks on the inputs, then
   calls the sample.eta(), sample.delta(), and sample.nu().
}
\details{
The direct sampling spatial prior model assumes that the spatial model can be written
 as the likelihood parameterised with mean vector nu and variance delta
 \deqn{(y | nu, delta) ~ N(nu, delta * I)}
 where I is the identity matrix.  The prior for the vector of spatial effects nu is
 improper but is proportional to
 \deqn{\pi(nu | eta) propto (det(M)/2\pi)^{1/2} * exp(-eta nu' M nu/2),}
 the prior for delta is assumed to be a inverse-gamma distribution
 \deqn{(delta) ~ IG(a,b)}
 and the prior for eta can be specified for the user as any valid density function for eta > 0.
}
\examples{
## Use the Meuse River dataset from the package 'gstat'

library(sp)
library(gstat)
data(meuse.all)
coordinates(meuse.all) <- ~ x + y

f <- function(x) -x ## log-prior for exponential distribution for the smoothing parameter

## Draw 100 samples from the posterior of eta given the data y.
OUTPUT <- DSSP(
  formula = log(zinc) ~ 1, data = meuse.all, N = 100,
  pars = c(0.001, 0.001), log_prior = f
)
}
