% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_pkpdmodel_ode.R
\name{simulate_pkpdmodel_ode}
\alias{simulate_pkpdmodel_ode}
\title{PkPd Virus model}
\usage{
simulate_pkpdmodel_ode(U = 1e+07, I = 0, V = 1, n = 0, dU = 0,
  dI = 1, dV = 2, b = 2e-07, g = 1, p = 5, C0 = 2, dC = 0.5,
  C50 = 1, k = 2, Emax = 1, txstart = 10, txinterval = 5,
  tstart = 0, tfinal = 30, dt = 0.1)
}
\arguments{
\item{U}{: initial number of uninfected target cells : numeric}

\item{I}{: initial number of infected target cells : numeric}

\item{V}{: initial number of infectious virions : numeric}

\item{n}{: rate of new uninfected cell replenishment : numeric}

\item{dU}{: rate at which uninfected cells die : numeric}

\item{dI}{: rate at which infected cells die : numeric}

\item{dV}{: rate at which infectious virus is cleared : numeric}

\item{b}{: rate at which virus infects cells : numeric}

\item{g}{: unit conversion factor : numeric}

\item{p}{: rate at which infected cells produce virus : numeric}

\item{C0}{: drug dose given at specified times : numeric}

\item{dC}{: drug concentration decay rate : numeric}

\item{C50}{: drug concentration at which effect is half maximum : numeric}

\item{k}{: steepness of concentration-dependent drug effect : numeric}

\item{Emax}{: maximum drug effect (0-1) : numeric}

\item{txstart}{: time of drug treatment start : numeric}

\item{txinterval}{: time between drug doses : numeric}

\item{tstart}{: Start time of simulation : numeric}

\item{tfinal}{: Final time of simulation : numeric}

\item{dt}{: Times for which result is returned : numeric}
}
\value{
A list. The list has only one element called ts.
ts contains the time-series of the simulation.
The 1st column of ts is Time, the other columns are the model variables.
}
\description{
This function runs a simulation of the basic 3 compartment
virus infection model including the pharmacokinetics and pharmacodynamics
of a drug. The user provides initial conditions and parameter values for the system.
The function simulates the ODE using an ODE solver from the deSolve package.
}
\details{
A basic virus infection model with drug PkPd

A simple compartmental model is simulated as a set of ordinary differential
equations, using an ode solver from the deSolve package.
This code is part of the DSAIRM R package.
For additional model details, see the corresponding app in the DSAIRM package.
}
\section{Warning}{
 This function does not perform any error checking. So if
  you try to do something nonsensical (e.g. specify negative parameter or starting values),
  the code will likely abort with an error message.
}

\examples{
# To run the simulation with default parameters just call the function:
result <- simulate_pkpdmodel_ode()
# To choose parameter values other than the standard one, specify them, like such:
result <- simulate_pkpdmodel_ode(V = 100, txstart = 10, n = 1e5, dU = 1e-2)
# You should then use the simulation result returned from the function, like this:
plot(result$ts[,"time"],result$ts[,"V"],xlab='Time',ylab='Virus',type='l',log='y')
}
\seealso{
See the Shiny app documentation corresponding to this simulator
function for more details on this model. See the manual for the deSolve
package for details on the underlying ODE simulator algorithm.
}
\author{
Andreas Handel
}
