% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{get_colours}
\alias{get_colours}
\title{Return colour-blind friendly colours}
\usage{
get_colours(vars, FG = NULL)
}
\arguments{
\item{vars}{Either a numeric value `n` to get n colours, or a character
vector of values where each value will be mapped to a colour.}

\item{FG}{A character vector describing the functional grouping to which each
variable belongs. Variables within the same group will have
different shades of the same colour.}
}
\value{
A named vector containing the hex codes of colours
}
\description{
Utility function to return either a distinct colour-blind friendly colour
for each variable or if a functional grouping is specified, then shades of
the same colour for variables within a functional group
}
\examples{
## Get n colours
get_colours(vars = 4)

# Get a color-map for each value specified in vars
get_colours(vars = c("p1", "p2", "p3", "p4"))

# Group values of vars using FG. Variables in the same group
# will have same shades of a colour
get_colours(vars = 4, FG = c("G1", "G1", "G2", "G2"))
}
