% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.vimp.covregrf.R
\name{plot.vimp.covregrf}
\alias{plot.vimp.covregrf}
\alias{plot.vimp}
\title{Plot variable importance measures for covregrf objects}
\usage{
\method{plot.vimp}{covregrf}(x, sort = TRUE, ndisp = NULL, ...)
}
\arguments{
\item{x}{An object of class (covregrf, grow) or (covregrf, vimp).}

\item{sort}{Should the covariates be sorted according to their variable
importance measures in the plot? The default is \code{TRUE}.}

\item{ndisp}{Number of covariates to display in the plot. If \code{sort}=
\code{TRUE}, the most important \code{ndisp} covariates will be plotted.
Otherwise, the first \code{ndisp} covariates in the original call will be
plotted. The default value is \code{NULL} which will plot all covariates.}

\item{...}{Optional arguments to be passed to other methods.}
}
\value{
Invisibly, the variable importance measures that were plotted.
}
\description{
Plots variable importance measures (VIMP) for covariates for training data.
}
\examples{
options(rf.cores=2, mc.cores=2)

## load generated example data
data(data, package = "CovRegRF")
xvar.names <- colnames(data$X)
yvar.names <- colnames(data$Y)
data1 <- data.frame(data$X, data$Y)

## define train/test split
set.seed(2345)
smp <- sample(1:nrow(data1), size = round(nrow(data1)*0.6), replace = FALSE)
traindata <- data1[smp,,drop=FALSE]
testdata <- data1[-smp, xvar.names, drop=FALSE]

## formula object
formula <- as.formula(paste(paste(yvar.names, collapse="+"), ".", sep=" ~ "))

## train covregrf
covregrf.obj <- covregrf(formula, traindata, params.rfsrc = list(ntree = 50),
  importance = TRUE)

## plot vimp
plot.vimp(covregrf.obj)


}
\seealso{
\code{\link{vimp.covregrf}}
}
