% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{dead_lianas_df}
\alias{dead_lianas_df}
\title{Mortality of lianas (vines) in tropical forests}
\format{
A data frame with 4,247 observations and 52 variables:
\describe{
  \item{PlotSite}{Plot site identifier (character)}
  \item{Y.Plot}{Y coordinate of the plot (numeric)}
  \item{X.Plot}{X coordinate of the plot (numeric)}
  \item{PhoroNo}{Phorophyte number (integer)}
  \item{EpiFam}{Epiphyte family (character)}
  \item{EpiGen}{Epiphyte genus (character)}
  \item{cf.aff}{Taxonomic uncertainty or affiliation (character)}
  \item{Species}{Epiphyte species name (character)}
  \item{Author}{Species author (character)}
  \item{EpiAzi}{Epiphyte azimuth (character)}
  \item{BraAzi}{Branch azimuth (integer)}
  \item{EpiDisTru}{Epiphyte distance from trunk (numeric)}
  \item{EpiSize}{Epiphyte size (numeric)}
  \item{EpiAttHei}{Epiphyte attachment height (numeric)}
  \item{Date0}{Initial survey date (Date)}
  \item{Date1}{Follow-up survey date (Date)}
  \item{Location}{Location name (character)}
  \item{Mortality}{Mortality status (factor with 2 levels)}
  \item{MorCat}{Mortality category (character)}
  \item{Elevation}{Elevation in meters (integer)}
  \item{AP_bio12}{Annual precipitation (integer)}
  \item{PDM_bio14}{Precipitation of driest month (integer)}
  \item{PS_bio15}{Precipitation seasonality (integer)}
  \item{MDT_bio2}{Mean diurnal temperature range (integer)}
  \item{TS_bio4}{Temperature seasonality (integer)}
  \item{ATR_bio7}{Annual temperature range (integer)}
  \item{AET}{Actual evapotranspiration (integer)}
  \item{BasAre}{Basal area (numeric)}
  \item{BasAre5_10}{Basal area of trees 5–10 cm DBH (numeric)}
  \item{BasAre10}{Basal area of trees \eqn{\ge}{>=} 10 cm DBH (numeric)}
  \item{Ind10}{Number of individuals \eqn{\ge}{>=} 10 cm DBH (integer)}
  \item{Ind5}{Number of individuals \eqn{\ge}{>=} 5 cm DBH (numeric)}
  \item{Ind5_10}{Number of individuals 5–10 cm DBH (numeric)}
  \item{Ind10_15}{Number of individuals 10–15 cm DBH (integer)}
  \item{Ind15_20}{Number of individuals 15–20 cm DBH (integer)}
  \item{Ind20_25}{Number of individuals 20–25 cm DBH (integer)}
  \item{Ind25_30}{Number of individuals 25–30 cm DBH (integer)}
  \item{Ind30}{Number of individuals \eqn{\ge}{>=} 30 cm DBH (integer)}
  \item{TreeHei}{Tree height (numeric)}
  \item{MedHei}{Median tree height (numeric)}
  \item{MaxHei}{Maximum tree height (numeric)}
  \item{BranchNumb}{Number of branches (integer)}
  \item{MEAH}{Mean epiphyte attachment height (numeric)}
  \item{MEAH_sd}{Standard deviation of mean epiphyte attachment height (numeric)}
  \item{MSP}{Mean species per phorophyte (integer)}
  \item{MSP_sd}{Standard deviation of mean species per phorophyte (integer)}
  \item{Htree}{Mean tree height (numeric)}
  \item{Htree_sd}{Standard deviation of mean tree height (numeric)}
  \item{BranNum}{Mean branch number (numeric)}
  \item{BranNUm_sd}{Standard deviation of branch number (numeric)}
  \item{tree.id}{Tree identifier (character)}
  \item{dead}{Tree mortality status (factor with 2 levels)}
}
}
\source{
Data taken from the \pkg{biometrics} package version 1.0.2
}
\usage{
data(dead_lianas_df)
}
\description{
This dataset, 'dead_lianas_df', is a data frame containing information on the mortality
of vascular epiphytes (lianas) in tropical forests of the Colombian Andes. The study
is part of the project "Diversity and dynamics of vascular epiphytes in Colombian Andes"
supported by COLCIENCIAS (contract 2115-2013). The data corresponds to the first large-scale
assessment of vascular epiphyte mortality in the neotropics.
}
\details{
The dataset name has been kept as 'dead_lianas_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
ColombiAPI package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame object. The original content has not
been modified in any way.
}
