% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GraphicsPredictionBPBM.R
\name{GraphicsPredictionBPBM}
\alias{GraphicsPredictionBPBM}
\title{Plots the time series}
\usage{
GraphicsPredictionBPBM(
  especie.All,
  names.especie,
  ExpectedValue.All,
  VarianceValue.All,
  Pred,
  Plot.Tipe,
  Varmas,
  Varmenos,
  Detail
)
}
\arguments{
\item{especie.All}{Matrix that contains at row i the bacterial taxa of bacteria i at all time points.}

\item{names.especie}{Vector with the names of the bacteria in the same order that are placed in the \code{especie} matrix.}

\item{ExpectedValue.All}{Matrix that contains at row i the expected value of the bacterial taxa i at all time points. The bacteria must be placed in the same order than in \code{especie}. This matrix must  comply: dim(ExpectedValue.All)[2]=dim(especie.All)[2]-1}

\item{VarianceValue.All}{Matrix that contains at row i the variance of the bacterial taxa i at all time points. The bacteria must be placed in the same order than in \code{especie}.This matrix must  comply: dim(VarianceValue.All)[2]=dim(especie.All)[2]-1}

\item{Pred}{Number. Indicates the time point in which we start predicting.}

\item{Plot.Tipe}{Character. If \code{Plot.Tipe==Data} the function displays a graphic of the dataset, if \code{Plot.Tipe==DataExpected} the function displays a graphic of the data and the expected values, if \code{Plot.Tipe==All} the function displays a graphic with the data, the expected values and the variance (the varmas and varmenos parameters are introduce and are taken into account to plot the variance of the predicted part).If  \code{Plot.Tipe==Var} the function returns the boxplot of the variance at each time point and the variance of each bacteria. If  \code{Plot.Tipe==OnlyVar} the function returns the boxplots of the variance at each time points.}

\item{Varmas}{Matrix. Output of "PredictionBPBM" adding "$ExpVarmas". Matrix that contains at row i the expected value plus two times the sqrt(variance) of the bacteria i at all time points t=\code{Tt},...,K, the rest of the time points has 0 values. The bacteria are placed at the same order than in \code{especies}.}

\item{Varmenos}{Matrix. Output of "PredictionBPBM" adding "$ExpVarmenos". Matrix that contains at row i the expected value minus two times the sqrt(variance) of the bacteria i at all time points t=\code{Tt},...,K, the rest of the time points has 0 values. The bacteria are placed at the same order than in \code{especies}.}

\item{Detail}{Character. If \code{Detail==no} the graphic obtained when \code{Plot.Tipe==DataExpected} and \code{Plot.Tipe==All} will have the same y axis for all the taxa. If \code{Detail==yes} these functions will have different y axis.}
}
\value{
Returns the indicated plots with a vertical line when the time point is equal to \code{Tt}=Pred-1, in Pred=\code{Tt}+1 the predicction has started.
}
\description{
This function takes into account the data used to estimate and the data used to predict. We use this function when we want to observe the results obtained with the BPBM model.
}
\examples{


names.especie=c("Bact1", "Bact2", "Bact3")
especie.All=cbind(c(0.5,0.3,0.2),
                 c(0.6,0.3,0.1),
                 c(0.4,0.1,0.5),
                 c(0.4,0.1,0.5),
                 c(0.4,0.1,0.5),
                 c(0.4,0.1,0.5))
ExpectedValue.All=especie.All[,-1]+0.1
VarianceValue.All=matrix(c(runif(15,0.001,0.004)), 3,5)
Pred=4
Varmas=cbind(matrix(0,3,2),matrix(c(runif(9,0.001,0.004)) ,3 ,3 ))
Varmenos=cbind(matrix(0,3,2),matrix(c(runif(9,0.001,0.004)) ,3 ,3 ))

GraphicsPredictionBPBM(especie.All,
                      names.especie,
                      ExpectedValue.All,
                      VarianceValue.All ,
                      Pred ,
                      "Data",
                      Varmas,
                      Varmenos,
                      "no")

GraphicsPredictionBPBM(especie.All,
                      names.especie,
                      ExpectedValue.All,
                      VarianceValue.All ,
                      Pred ,
                      "DataExpected",
                      Varmas,
                      Varmenos,
                      "no")

GraphicsPredictionBPBM(especie.All,
                      names.especie,
                      ExpectedValue.All,
                      VarianceValue.All,
                      Pred ,
                      "All",
                      Varmas,
                      Varmenos,
                      "no")

GraphicsPredictionBPBM(especie.All,
                      names.especie,
                      ExpectedValue.All,
                      VarianceValue.All ,
                      Pred ,
                      "Var",
                      Varmas,
                      Varmenos,
                      "no")

GraphicsPredictionBPBM(especie.All,
                      names.especie,
                      ExpectedValue.All,
                      VarianceValue.All ,
                      Pred ,
                      "OnlyVar",
                      Varmas,
                      Varmenos,
                      "no")

}
\references{
Creus-Martí, I., Moya, A., Santonja, F. J. (2022). Bayesian hierarchical compositional models for analysing longitudinal abundance data from microbiome studies. Complexity, 2022.
}
