% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepwiseSearch.R
\name{stepwiseSearch}
\alias{stepwiseSearch}
\title{Executes an NLME stepwise covariate search}
\usage{
stepwiseSearch(
  model,
  hostPlatform = NULL,
  params,
  covariateModel,
  stepwiseParams,
  runInBackground = FALSE,
  ...
)
}
\arguments{
\item{model}{PK/PD model class object.}

\item{hostPlatform}{Host definition for model execution. See \code{\link{hostParams}}.
If \code{missing}, multicore local host with 4 threads is used.}

\item{params}{Engine parameters. See \code{\link{engineParams}}.
If \code{missing}, default parameters generated by engineParams(model) are used.}

\item{covariateModel}{Covariate Effects Model providing the relationship
between covariates and structural parameters to test (\code{covariateModel(model)}).}

\item{stepwiseParams}{Stepwise parameters defining decision tree.
See \code{\link{StepwiseParams}}}

\item{runInBackground}{Set to \code{TRUE} to run in background and return prompt.}

\item{...}{Additional arguments for  \code{\link{hostParams}}
or arguments available inside \code{\link{engineParams}} functions.
If \code{\link{engineParams}} arguments are supplied through both \code{params} argument
and additional argument (i.e., ellipsis), then the arguments in \code{params} will be ignored
and only the additional arguments will be used with warning.
If \code{\link{hostParams}} arguments are supplied through both the \code{hostPlatform}
argument and the ellipses, values supplied to \code{hostPlatform} will be overridden by
additional arguments supplied via the ellipses e.g., \code{...}.}
}
\value{
if \code{runInBackground = FALSE}, a data frame is returned with
stepwise search results, i.e. "Overall" comma separated file.
Otherwise the \code{StepwiseNlmeJob} class object is returned.
}
\description{
Executes an NLME stepwise covariate search
}
\examples{
\donttest{
# Define the model
model <- pkmodel(numCompartments = 2,
                 data = pkData,
                 ID = "Subject",
                 Time = "Act_Time",
                 A1 = "Amount",
                 CObs = "Conc")

# Add Gender covariate of type categorical
model <- addCovariate(model,
                      covariate = "Gender",
                      type = "Categorical",
                      effect = c("V2", "Cl2"),
                      levels = c(0, 1),
                      labels = c("Female", "Male"))

# Add Bodyweight covariate of type continuous
model <- addCovariate(model,
             covariate = "BodyWeight",
             type = "Continuous",
             direction = "Backward",
             center = "Mean",
             effect = c("V", "Cl"))

# Define the host
defaultHost <- hostParams(parallelMethod = "None",
                   hostName = "local",
                   numCores = 1)

# Define the engine parameters
params <- engineParams(model)

# Define covariate model
cp <- covariateModel(model)

# Define the stepwise parameters
sp <- StepwiseParams(0.01, 0.001, "-2LL")

# Perform stepwise search
OverallDF <-  stepwiseSearch(model = model,
                      hostPlatform = defaultHost,
                      params = params,
                      covariateModel = cp,
                      stepwiseParams = sp,
                      runInBackground = FALSE)
}

}
\seealso{
\code{\link{hostParams}, \link{engineParams}}
}
