% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uneFonction.R
\name{summary.lmps}
\alias{summary.lmps}
\title{Summary function for our lmps object}
\usage{
\method{summary}{lmps}(object, ...)
}
\arguments{
\item{object}{Our lmps object}

\item{...}{Other arguments ignored (for compatibility with generic)}
}
\value{
A summary of our lmps object
}
\description{
Summary function for our lmps object
}
\details{
This function provides a summary of the data collected during the application of the lmps function.
It summarizes how many times the most frequently selected model was chosen across our N divisions, as well as
the selection frequency of variables in the different divisions.
It can also provide the execution time of the lmps function, which may vary significantly depending on the chosen post-selection method and the dimensionality of our data.
}
\examples{
library(mlbench)
data("BostonHousing")
# lmps object
model = lmps(medv~., data = BostonHousing, method = "Lasso", N = 50)
summary(model)


\donttest{
# lmps object
model = lmps(medv~., data = BostonHousing, method = "Lasso", N = 50, cores = 2)
summary(model)
}
}
