% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getIDER.R
\name{getIDEr}
\alias{getIDEr}
\title{Compute IDER-Based Similarity}
\usage{
getIDEr(
  seu,
  group.by.var = "initial_cluster",
  batch.by.var = "Batch",
  verbose = TRUE,
  use.parallel = FALSE,
  n.cores = 1,
  downsampling.size = 40,
  downsampling.include = TRUE,
  downsampling.replace = TRUE
)
}
\arguments{
\item{seu}{A Seurat S4 object that includes an \code{initial_cluster} column in its \code{meta.data}. Required.}

\item{group.by.var}{Character string specifying the column in \code{seu@meta.data} 
that defines initial clusters (batch-specific groups). Default is "initial_cluster".}

\item{batch.by.var}{Character string specifying the metadata column that indicates batch information. Default is "Batch".}

\item{verbose}{Logical. If \code{TRUE}, progress messages and a progress bar are displayed. Default is \code{TRUE}.}

\item{use.parallel}{Logical. If \code{TRUE}, parallel computation is used
(requires \code{doParallel}); in this case, no progress bar will be shown. Default is \code{FALSE}.}

\item{n.cores}{Numeric. The number of cores to use for parallel computing. Default is 1.}

\item{downsampling.size}{Numeric. The number of cells representing each group. Default is 40.}

\item{downsampling.include}{Logical. Whether to include groups with fewer 
cells than \code{downsampling.size}. Default is \code{FALSE}.}

\item{downsampling.replace}{Logical. Whether to sample with replacement if a 
group is smaller than \code{downsampling.size}. Default is \code{FALSE}.}
}
\value{
A list of objects: a similarity matrix, a numeric vector recording 
the cells used, and a data frame of the group combinations included.
}
\description{
Calculate the similarity matrix based on Inter-group Differential Expression 
(IDER) metrics with the selected batch effects regressed out.
}
\seealso{
\code{\link{plotNetwork}}, \code{\link{finalClustering}}
}
