% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDistMat.R
\name{getDistMat}
\alias{getDistMat}
\title{Calculate the Similarity Matrix}
\usage{
getDistMat(
  seu_list,
  verbose = TRUE,
  tmp.initial.clusters = "seurat_clusters",
  method = "trend",
  batch.var = "Batch",
  additional.variate = NULL,
  downsampling.size = 35,
  downsampling.include = TRUE,
  downsampling.replace = TRUE
)
}
\arguments{
\item{seu_list}{A list containing Seurat objects. Required.}

\item{verbose}{Logical. If \code{TRUE}, progress messages and a progress bar are displayed. Default is \code{TRUE}.}

\item{tmp.initial.clusters}{Character string specifying one of the column names from \code{Seurat@meta.data} 
that denotes groups, e.g., initial clusters. 
Default is "seurat_clusters".}

\item{method}{Character string specifying the method for differential expression analysis.
Options are "voom" or "trend" (default is "trend").}

\item{batch.var}{Character string specifying the metadata column containing batch information. Default is "Batch".}

\item{additional.variate}{Character vector of additional variates to include in the linear model for regression.}

\item{downsampling.size}{Numeric value indicating the number of cells to use per group. Default is 35.}

\item{downsampling.include}{Logical. Whether to include groups with fewer cells than 
\code{downsampling.size}. Default is \code{TRUE}.}

\item{downsampling.replace}{Logical. Whether to sample with replacement for groups 
smaller than \code{downsampling.size}. Default is \code{TRUE}.}
}
\value{
A list of similarity matrices.
}
\description{
Compute the IDER-based similarity matrix for a list of Seurat objects. This 
function does not regress out batch effects and is designed for use during the initial clustering step.
}
\seealso{
\code{\link{calculateDistMatOneModel}}
}
