#'Compute Likelihood Ratio Chi-square for Binomial Logistic Regression with up to 10 predictors
#'
#'@param data name of your datafile, loaded
#'@param  y dependent variable name
#'@param  x1 first predictor variable name
#'@param  x2 second predictor variable name
#'@param  x3 third predictor variable name
#'@param  x4 fourth predictor variable name
#'@param  x5 fifth predictor variable name
#'@param  x6 sixth predictor variable name
#'@param  x7 seventh predictor variable name
#'@param  x8 eighth predictor variable name
#'@param  x9 ninth predictor variable name
#'@param  x10 tenth predictor variable name
#'@param  numpred number of predict#'ors
#'@examples
#'LRchi(data=testlog, y="dv", x1="iv1", x2="iv2",numpred=2)
#'@return Likelihood Ratio Chi-square for Logistic Regression with up to 10 predictors
#'@importFrom stats anova binomial glm hatvalues
#'@importFrom utils tail
#'@export
#'
#'
LRchi<-function(data=NULL,y=NULL, x1=NULL, x2=NULL,x3=NULL,x4=NULL,x5=NULL,x6=NULL,
                x7=NULL,x8=NULL,x9=NULL,x10=NULL,numpred=NULL){

if (numpred ==2)
  {
xx<-dplyr::select(data,y,x1,x2)
xx<-as.data.frame(xx)
Model<-glm(xx[,1]~xx[,2]+xx[,3], family = binomial())
Model.1<-glm(xx[,1]~xx[,3], family = binomial())
Model.2<-glm(xx[,1]~xx[,2], family = binomial())
comp.1<-anova(Model.1,Model, test="Chisq")
comp.2<-anova(Model.2,Model, test="Chisq")
LR.1<-round(comp.1$Deviance[2],2)
p.1<-round(comp.1$`Pr(>Chi)`[2],2)
LR.2<-round(comp.2$Deviance[2],2)
p.2<-round(comp.2$`Pr(>Chi)`[2],2)
message("Predictor: ", x1, "; LR squared ",LR.1, ", p= ", p.1)
message("Predictor: ", x2, "; LR squared ",LR.2, ", p= ", p.2)
}
  if (numpred ==3)
{
xx<-dplyr::select(data,y,x1,x2,x3)
xx<-as.data.frame(xx)
Model<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4], family = binomial())
Model.1<-glm(xx[,1]~xx[,3]+xx[,4], family = binomial())
Model.2<-glm(xx[,1]~xx[,2]+xx[,4], family = binomial())
Model.3<-glm(xx[,1]~xx[,2]+xx[,3], family = binomial())
comp.1<-anova(Model.1,Model, test="Chisq")
comp.2<-anova(Model.2,Model, test="Chisq")
comp.3<-anova(Model.3,Model, test="Chisq")
LR.1<-round(comp.1$Deviance[2],2)
p.1<-round(comp.1$`Pr(>Chi)`[2],2)
LR.2<-round(comp.2$Deviance[2],2)
p.2<-round(comp.2$`Pr(>Chi)`[2],2)
LR.3<-round(comp.3$Deviance[2],2)
p.3<-round(comp.3$`Pr(>Chi)`[2],2)

message("Predictor: ", x1, "; LR squared ",LR.1, ", p= ", p.1)
message("Predictor: ", x2, "; LR squared ",LR.2, ", p= ", p.2)
message("Predictor: ", x3, "; LR squared ",LR.3, ", p= ", p.3)
  }
  if (numpred ==4)
  {
    xx<-dplyr::select(data,y,x1,x2,x3,x4)
    xx<-as.data.frame(xx)
    Model<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5], family = binomial())
    Model.1<-glm(xx[,1]~xx[,3]+xx[,4]+xx[,5], family = binomial())
    Model.2<-glm(xx[,1]~xx[,2]+xx[,4]+xx[,5], family = binomial())
    Model.3<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,5], family = binomial())
    Model.4<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4], family = binomial())
    comp.1<-anova(Model.1,Model, test="Chisq")
    comp.2<-anova(Model.2,Model, test="Chisq")
    comp.3<-anova(Model.3,Model, test="Chisq")
    comp.4<-anova(Model.4,Model, test="Chisq")
    LR.1<-round(comp.1$Deviance[2],2)
    p.1<-round(comp.1$`Pr(>Chi)`[2],2)
    LR.2<-round(comp.2$Deviance[2],2)
    p.2<-round(comp.2$`Pr(>Chi)`[2],2)
    LR.3<-round(comp.3$Deviance[2],2)
    p.3<-round(comp.3$`Pr(>Chi)`[2],2)
    LR.4<-round(comp.4$Deviance[2],2)
    p.4<-round(comp.4$`Pr(>Chi)`[2],2)

    message("Predictor: ", x1, "; LR squared ",LR.1, ", p= ", p.1)
    message("Predictor: ", x2, "; LR squared ",LR.2, ", p= ", p.2)
    message("Predictor: ", x3, "; LR squared ",LR.3, ", p= ", p.3)
    message("Predictor: ", x4, "; LR squared ",LR.4, ", p= ", p.4)
  }
  if (numpred ==5)
  {
    xx<-dplyr::select(data,y,x1,x2,x3,x4,x5)
    xx<-as.data.frame(xx)
    Model<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5]+xx[,6], family = binomial())
    Model.1<-glm(xx[,1]~xx[,3]+xx[,4]+xx[,5]+xx[,6], family = binomial())
    Model.2<-glm(xx[,1]~xx[,2]+xx[,4]+xx[,5]+xx[,6], family = binomial())
    Model.3<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,5]+xx[,6], family = binomial())
    Model.4<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,6], family = binomial())
    Model.5<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5], family = binomial())
    comp.1<-anova(Model.1,Model, test="Chisq")
    comp.2<-anova(Model.2,Model, test="Chisq")
    comp.3<-anova(Model.3,Model, test="Chisq")
    comp.4<-anova(Model.4,Model, test="Chisq")
    comp.5<-anova(Model.5,Model, test="Chisq")
    LR.1<-round(comp.1$Deviance[2],2)
    p.1<-round(comp.1$`Pr(>Chi)`[2],2)
    LR.2<-round(comp.2$Deviance[2],2)
    p.2<-round(comp.2$`Pr(>Chi)`[2],2)
    LR.3<-round(comp.3$Deviance[2],2)
    p.3<-round(comp.3$`Pr(>Chi)`[2],2)
    LR.4<-round(comp.4$Deviance[2],2)
    p.4<-round(comp.4$`Pr(>Chi)`[2],2)
    LR.5<-round(comp.5$Deviance[2],2)
    p.5<-round(comp.5$`Pr(>Chi)`[2],2)

    message("Predictor: ", x1, "; LR squared ",LR.1, ", p= ", p.1)
    message("Predictor: ", x2, "; LR squared ",LR.2, ", p= ", p.2)
    message("Predictor: ", x3, "; LR squared ",LR.3, ", p= ", p.3)
    message("Predictor: ", x4, "; LR squared ",LR.4, ", p= ", p.4)
    message("Predictor: ", x5, "; LR squared ",LR.5, ", p= ", p.5)

      }
  if (numpred ==6)
  {
    xx<-dplyr::select(data,y,x1,x2,x3,x4,x5,x6)
    xx<-as.data.frame(xx)
    Model<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5]+xx[,6]+xx[,7], family = binomial())
    Model.1<-glm(xx[,1]~xx[,3]+xx[,4]+xx[,5]+xx[,6]+xx[,7], family = binomial())
    Model.2<-glm(xx[,1]~xx[,2]+xx[,4]+xx[,5]+xx[,6]+xx[,7], family = binomial())
    Model.3<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,5]+xx[,6]+xx[,7], family = binomial())
    Model.4<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,6]+xx[,7], family = binomial())
    Model.5<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5]+xx[,7], family = binomial())
    Model.6<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5]+xx[,6], family = binomial())
    comp.1<-anova(Model.1,Model, test="Chisq")
    comp.2<-anova(Model.2,Model, test="Chisq")
    comp.3<-anova(Model.3,Model, test="Chisq")
    comp.4<-anova(Model.4,Model, test="Chisq")
    comp.5<-anova(Model.5,Model, test="Chisq")
    comp.6<-anova(Model.6,Model, test="Chisq")
    LR.1<-round(comp.1$Deviance[2],2)
    p.1<-round(comp.1$`Pr(>Chi)`[2],2)
    LR.2<-round(comp.2$Deviance[2],2)
    p.2<-round(comp.2$`Pr(>Chi)`[2],2)
    LR.3<-round(comp.3$Deviance[2],2)
    p.3<-round(comp.3$`Pr(>Chi)`[2],2)
    LR.4<-round(comp.4$Deviance[2],2)
    p.4<-round(comp.4$`Pr(>Chi)`[2],2)
    LR.5<-round(comp.5$Deviance[2],2)
    p.5<-round(comp.5$`Pr(>Chi)`[2],2)
    p.4<-round(comp.4$`Pr(>Chi)`[2],2)
    LR.6<-round(comp.6$Deviance[2],2)
    p.6<-round(comp.6$`Pr(>Chi)`[2],2)

    message("Predictor: ", x1, "; LR squared ",LR.1, ", p= ", p.1)
    message("Predictor: ", x2, "; LR squared ",LR.2, ", p= ", p.2)
    message("Predictor: ", x3, "; LR squared ",LR.3, ", p= ", p.3)
    message("Predictor: ", x4, "; LR squared ",LR.4, ", p= ", p.4)
    message("Predictor: ", x5, "; LR squared ",LR.5, ", p= ", p.5)
    message("Predictor: ", x6, "; LR squared ",LR.6, ", p= ", p.6)
  }

  if (numpred ==7)
  {
    xx<-dplyr::select(data,y,x1,x2,x3,x4,x5,x6,x7)
    xx<-as.data.frame(xx)
    Model<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5]+xx[,6]+xx[,7]+xx[,8], family = binomial())
    Model.1<-glm(xx[,1]~xx[,3]+xx[,4]+xx[,5]+xx[,6]+xx[,7]+xx[,8], family = binomial())
    Model.2<-glm(xx[,1]~xx[,2]+xx[,4]+xx[,5]+xx[,6]+xx[,7]+xx[,8], family = binomial())
    Model.3<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,5]+xx[,6]+xx[,7]+xx[,8], family = binomial())
    Model.4<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,6]+xx[,7]+xx[,8], family = binomial())
    Model.5<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5]+xx[,7]+xx[,8], family = binomial())
    Model.6<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5]+xx[,6]+xx[,8], family = binomial())
    Model.7<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5]+xx[,6]+xx[,7], family = binomial())
    comp.1<-anova(Model.1,Model, test="Chisq")
    comp.2<-anova(Model.2,Model, test="Chisq")
    comp.3<-anova(Model.3,Model, test="Chisq")
    comp.4<-anova(Model.4,Model, test="Chisq")
    comp.5<-anova(Model.5,Model, test="Chisq")
    comp.6<-anova(Model.6,Model, test="Chisq")
    comp.7<-anova(Model.7,Model, test="Chisq")
    LR.1<-round(comp.1$Deviance[2],2)
    p.1<-round(comp.1$`Pr(>Chi)`[2],2)
    LR.2<-round(comp.2$Deviance[2],2)
    p.2<-round(comp.2$`Pr(>Chi)`[2],2)
    LR.3<-round(comp.3$Deviance[2],2)
    p.3<-round(comp.3$`Pr(>Chi)`[2],2)
    LR.4<-round(comp.4$Deviance[2],2)
    p.4<-round(comp.4$`Pr(>Chi)`[2],2)
    LR.5<-round(comp.5$Deviance[2],2)
    p.5<-round(comp.5$`Pr(>Chi)`[2],2)
    p.4<-round(comp.4$`Pr(>Chi)`[2],2)
    LR.6<-round(comp.6$Deviance[2],2)
    p.6<-round(comp.6$`Pr(>Chi)`[2],2)
    LR.7<-round(comp.7$Deviance[2],2)
    p.7<-round(comp.7$`Pr(>Chi)`[2],2)

    message("Predictor: ", x1, "; LR squared ",LR.1, ", p= ", p.1)
    message("Predictor: ", x2, "; LR squared ",LR.2, ", p= ", p.2)
    message("Predictor: ", x3, "; LR squared ",LR.3, ", p= ", p.3)
    message("Predictor: ", x4, "; LR squared ",LR.4, ", p= ", p.4)
    message("Predictor: ", x5, "; LR squared ",LR.5, ", p= ", p.5)
    message("Predictor: ", x6, "; LR squared ",LR.6, ", p= ", p.6)
    message("Predictor: ", x7, "; LR squared ",LR.7, ", p= ", p.7)
      }
  if (numpred ==8)
  {
    xx<-dplyr::select(data,y,x1,x2,x3,x4,x5,x6,x7,x8)
    xx<-as.data.frame(xx)
    Model<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5]+xx[,6]+xx[,7]+xx[,8]+xx[,9], family = binomial())
    Model.1<-glm(xx[,1]~xx[,3]+xx[,4]+xx[,5]+xx[,6]+xx[,7]+xx[,8]+xx[,9], family = binomial())
    Model.2<-glm(xx[,1]~xx[,2]+xx[,4]+xx[,5]+xx[,6]+xx[,7]+xx[,8]+xx[,9], family = binomial())
    Model.3<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,5]+xx[,6]+xx[,7]+xx[,8]+xx[,9], family = binomial())
    Model.4<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,6]+xx[,7]+xx[,8]+xx[,9], family = binomial())
    Model.5<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5]+xx[,7]+xx[,8]+xx[,9], family = binomial())
    Model.6<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5]+xx[,6]+xx[,8]+xx[,9], family = binomial())
    Model.7<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5]+xx[,6]+xx[,7]+xx[,9], family = binomial())
    Model.8<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5]+xx[,6]+xx[,7]+xx[,8], family = binomial())
    comp.1<-anova(Model.1,Model, test="Chisq")
    comp.2<-anova(Model.2,Model, test="Chisq")
    comp.3<-anova(Model.3,Model, test="Chisq")
    comp.4<-anova(Model.4,Model, test="Chisq")
    comp.5<-anova(Model.5,Model, test="Chisq")
    comp.6<-anova(Model.6,Model, test="Chisq")
    comp.7<-anova(Model.7,Model, test="Chisq")
    comp.8<-anova(Model.8,Model, test="Chisq")
    LR.1<-round(comp.1$Deviance[2],2)
    p.1<-round(comp.1$`Pr(>Chi)`[2],2)
    LR.2<-round(comp.2$Deviance[2],2)
    p.2<-round(comp.2$`Pr(>Chi)`[2],2)
    LR.3<-round(comp.3$Deviance[2],2)
    p.3<-round(comp.3$`Pr(>Chi)`[2],2)
    LR.4<-round(comp.4$Deviance[2],2)
    p.4<-round(comp.4$`Pr(>Chi)`[2],2)
    LR.5<-round(comp.5$Deviance[2],2)
    p.5<-round(comp.5$`Pr(>Chi)`[2],2)
    p.4<-round(comp.4$`Pr(>Chi)`[2],2)
    LR.6<-round(comp.6$Deviance[2],2)
    p.6<-round(comp.6$`Pr(>Chi)`[2],2)
    LR.7<-round(comp.7$Deviance[2],2)
    p.7<-round(comp.7$`Pr(>Chi)`[2],2)
    LR.8<-round(comp.8$Deviance[2],2)
    p.8<-round(comp.8$`Pr(>Chi)`[2],2)

    message("Predictor: ", x1, "; LR squared ",LR.1, ", p= ", p.1)
    message("Predictor: ", x2, "; LR squared ",LR.2, ", p= ", p.2)
    message("Predictor: ", x3, "; LR squared ",LR.3, ", p= ", p.3)
    message("Predictor: ", x4, "; LR squared ",LR.4, ", p= ", p.4)
    message("Predictor: ", x5, "; LR squared ",LR.5, ", p= ", p.5)
    message("Predictor: ", x6, "; LR squared ",LR.6, ", p= ", p.6)
    message("Predictor: ", x7, "; LR squared ",LR.7, ", p= ", p.7)
    message("Predictor: ", x8, "; LR squared ",LR.8, ", p= ", p.8)

      }
  if (numpred ==9)
  {
    xx<-dplyr::select(data,y,x1,x2,x3,x4,x5,x6,x7,x8,x9)
    xx<-as.data.frame(xx)
    Model<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5]+xx[,6]+xx[,7]+xx[,8]+xx[,9]+xx[,10], family = binomial())
    Model.1<-glm(xx[,1]~xx[,3]+xx[,4]+xx[,5]+xx[,6]+xx[,7]+xx[,8]+xx[,9]+xx[,10], family = binomial())
    Model.2<-glm(xx[,1]~xx[,2]+xx[,4]+xx[,5]+xx[,6]+xx[,7]+xx[,8]+xx[,9]+xx[,10], family = binomial())
    Model.3<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,5]+xx[,6]+xx[,7]+xx[,8]+xx[,9]+xx[,10], family = binomial())
    Model.4<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,6]+xx[,7]+xx[,8]+xx[,9]+xx[,10], family = binomial())
    Model.5<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5]+xx[,7]+xx[,8]+xx[,9]+xx[,10], family = binomial())
    Model.6<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5]+xx[,6]+xx[,8]+xx[,9]+xx[,10], family = binomial())
    Model.7<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5]+xx[,6]+xx[,7]+xx[,9]+xx[,10], family = binomial())
    Model.8<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5]+xx[,6]+xx[,7]+xx[,8]+xx[,10], family = binomial())
    Model.9<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5]+xx[,6]+xx[,7]+xx[,8]+xx[,9], family = binomial())
    comp.1<-anova(Model.1,Model, test="Chisq")
    comp.2<-anova(Model.2,Model, test="Chisq")
    comp.3<-anova(Model.3,Model, test="Chisq")
    comp.4<-anova(Model.4,Model, test="Chisq")
    comp.5<-anova(Model.5,Model, test="Chisq")
    comp.6<-anova(Model.6,Model, test="Chisq")
    comp.7<-anova(Model.7,Model, test="Chisq")
    comp.8<-anova(Model.8,Model, test="Chisq")
    comp.9<-anova(Model.9,Model, test="Chisq")
    LR.1<-round(comp.1$Deviance[2],2)
    p.1<-round(comp.1$`Pr(>Chi)`[2],2)
    LR.2<-round(comp.2$Deviance[2],2)
    p.2<-round(comp.2$`Pr(>Chi)`[2],2)
    LR.3<-round(comp.3$Deviance[2],2)
    p.3<-round(comp.3$`Pr(>Chi)`[2],2)
    LR.4<-round(comp.4$Deviance[2],2)
    p.4<-round(comp.4$`Pr(>Chi)`[2],2)
    LR.5<-round(comp.5$Deviance[2],2)
    p.5<-round(comp.5$`Pr(>Chi)`[2],2)
    p.4<-round(comp.4$`Pr(>Chi)`[2],2)
    LR.6<-round(comp.6$Deviance[2],2)
    p.6<-round(comp.6$`Pr(>Chi)`[2],2)
    LR.7<-round(comp.7$Deviance[2],2)
    p.7<-round(comp.7$`Pr(>Chi)`[2],2)
    LR.8<-round(comp.8$Deviance[2],2)
    p.8<-round(comp.8$`Pr(>Chi)`[2],2)
    LR.9<-round(comp.9$Deviance[2],2)
    p.9<-round(comp.9$`Pr(>Chi)`[2],2)

    message("Predictor: ", x1, "; LR squared ",LR.1, ", p= ", p.1)
    message("Predictor: ", x2, "; LR squared ",LR.2, ", p= ", p.2)
    message("Predictor: ", x3, "; LR squared ",LR.3, ", p= ", p.3)
    message("Predictor: ", x4, "; LR squared ",LR.4, ", p= ", p.4)
    message("Predictor: ", x5, "; LR squared ",LR.5, ", p= ", p.5)
    message("Predictor: ", x6, "; LR squared ",LR.6, ", p= ", p.6)
    message("Predictor: ", x7, "; LR squared ",LR.7, ", p= ", p.7)
    message("Predictor: ", x8, "; LR squared ",LR.8, ", p= ", p.8)
    message("Predictor: ", x9, "; LR squared ",LR.9, ", p= ", p.9)
  }
  if (numpred ==10)
  {
    xx<-dplyr::select(data,y,x1,x2,x3,x4,x5,x6,x7,x8,x9,x10)
    xx<-as.data.frame(xx)
    Model<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5]+xx[,6]+xx[,7]+xx[,8]+xx[,9]+xx[,10]+xx[,11], family = binomial())
    Model.1<-glm(xx[,1]~xx[,3]+xx[,4]+xx[,5]+xx[,6]+xx[,7]+xx[,8]+xx[,9]+xx[,10]+xx[,11], family = binomial())
    Model.2<-glm(xx[,1]~xx[,2]+xx[,4]+xx[,5]+xx[,6]+xx[,7]+xx[,8]+xx[,9]+xx[,10]+xx[,11], family = binomial())
    Model.3<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,5]+xx[,6]+xx[,7]+xx[,8]+xx[,9]+xx[,10]+xx[,11], family = binomial())
    Model.4<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,6]+xx[,7]+xx[,8]+xx[,9]+xx[,10]+xx[,11], family = binomial())
    Model.5<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5]+xx[,7]+xx[,8]+xx[,9]+xx[,10]+xx[,11], family = binomial())
    Model.6<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5]+xx[,6]+xx[,8]+xx[,9]+xx[,10]+xx[,11], family = binomial())
    Model.7<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5]+xx[,6]+xx[,7]+xx[,9]+xx[,10]+xx[,11], family = binomial())
    Model.8<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5]+xx[,6]+xx[,7]+xx[,8]+xx[,10]+xx[,11], family = binomial())
    Model.9<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5]+xx[,6]+xx[,7]+xx[,8]+xx[,9]+xx[,11], family = binomial())
    Model.10<-glm(xx[,1]~xx[,2]+xx[,3]+xx[,4]+xx[,5]+xx[,6]+xx[,7]+xx[,8]+xx[,9]+xx[,10], family = binomial())
    comp.1<-anova(Model.1,Model, test="Chisq")
    comp.2<-anova(Model.2,Model, test="Chisq")
    comp.3<-anova(Model.3,Model, test="Chisq")
    comp.4<-anova(Model.4,Model, test="Chisq")
    comp.5<-anova(Model.5,Model, test="Chisq")
    comp.6<-anova(Model.6,Model, test="Chisq")
    comp.7<-anova(Model.7,Model, test="Chisq")
    comp.8<-anova(Model.8,Model, test="Chisq")
    comp.9<-anova(Model.9,Model, test="Chisq")
    comp.10<-anova(Model.10,Model, test="Chisq")
    LR.1<-round(comp.1$Deviance[2],2)
    p.1<-round(comp.1$`Pr(>Chi)`[2],2)
    LR.2<-round(comp.2$Deviance[2],2)
    p.2<-round(comp.2$`Pr(>Chi)`[2],2)
    LR.3<-round(comp.3$Deviance[2],2)
    p.3<-round(comp.3$`Pr(>Chi)`[2],2)
    LR.4<-round(comp.4$Deviance[2],2)
    p.4<-round(comp.4$`Pr(>Chi)`[2],2)
    LR.5<-round(comp.5$Deviance[2],2)
    p.5<-round(comp.5$`Pr(>Chi)`[2],2)
    p.4<-round(comp.4$`Pr(>Chi)`[2],2)
    LR.6<-round(comp.6$Deviance[2],2)
    p.6<-round(comp.6$`Pr(>Chi)`[2],2)
    LR.7<-round(comp.7$Deviance[2],2)
    p.7<-round(comp.7$`Pr(>Chi)`[2],2)
    LR.8<-round(comp.8$Deviance[2],2)
    p.8<-round(comp.8$`Pr(>Chi)`[2],2)
    LR.9<-round(comp.9$Deviance[2],2)
    p.9<-round(comp.9$`Pr(>Chi)`[2],2)
    LR.10<-round(comp.10$Deviance[2],2)
    p.10<-round(comp.10$`Pr(>Chi)`[2],2)


    message("Predictor: ", x1, "; LR squared ",LR.1, ", p= ", p.1)
    message("Predictor: ", x2, "; LR squared ",LR.2, ", p= ", p.2)
    message("Predictor: ", x3, "; LR squared ",LR.3, ", p= ", p.3)
    message("Predictor: ", x4, "; LR squared ",LR.4, ", p= ", p.4)
    message("Predictor: ", x5, "; LR squared ",LR.5, ", p= ", p.5)
    message("Predictor: ", x6, "; LR squared ",LR.6, ", p= ", p.6)
    message("Predictor: ", x7, "; LR squared ",LR.7, ", p= ", p.7)
    message("Predictor: ", x8, "; LR squared ",LR.8, ", p= ", p.8)
    message("Predictor: ", x9, "; LR squared ",LR.9, ", p= ", p.9)
    message("Predictor: ", x10, "; LR squared ",LR.10, ", p= ", p.10)
  }

  }

