% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_mortality.R
\name{posterior_mortality}
\alias{posterior_mortality}
\title{Summarize the posterior distribution of the mortality counts}
\usage{
posterior_mortality(object, y_data)
}
\arguments{
\item{object}{An object of class \code{stanigbm}. See \code{\link[Bernadette]{stan_igbm}}.}

\item{y_data}{data.frame;
age-specific mortality counts in time. See \code{data(age_specific_mortality_counts)}.}
}
\value{
#' A named list with elements \code{Age_specific} and \code{Aggregated} which can be visualised using \code{\link[Bernadette]{plot_posterior_mortality}}.
}
\description{
Summarize the posterior distribution of the mortality counts
}
\examples{
\donttest{
# Age-specific mortality/incidence count time series:
data(age_specific_mortality_counts)
data(age_specific_infection_counts)

# Import the age distribution for Greece in 2020:
age_distr <- age_distribution(country = "Greece", year = 2020)

# Lookup table:
lookup_table <- data.frame(Initial = age_distr$AgeGrp,
                          Mapping = c(rep("0-39",  8),
                                      rep("40-64", 5),
                                      rep("65+"  , 3)))

# Aggregate the age distribution table:
aggr_age <- aggregate_age_distribution(age_distr, lookup_table)

# Import the projected contact matrix for Greece:
conmat <- contact_matrix(country = "GRC")

# Aggregate the contact matrix:
aggr_cm <- aggregate_contact_matrix(conmat, lookup_table, aggr_age)

# Aggregate the IFR:
ifr_mapping <- c(rep("0-39", 8), rep("40-64", 5), rep("65+", 3))

aggr_age_ifr <- aggregate_ifr_react(age_distr, ifr_mapping, age_specific_infection_counts)

# Infection-to-death distribution:
ditd <- itd_distribution(ts_length  = nrow(age_specific_mortality_counts),
                         gamma_mean = 24.19231,
                         gamma_cv   = 0.3987261)

# Posterior sampling:
igbm_fit <- stan_igbm(y_data                      = age_specific_mortality_counts,
                      contact_matrix              = aggr_cm,
                      age_distribution_population = aggr_age,
                      age_specific_ifr            = aggr_age_ifr[[3]],
                      itd_distr                   = ditd,
                      likelihood_variance_type    = "quadratic",
                      prior_volatility            = normal(location = 0, scale = 1),
                      prior_nb_dispersion         = gamma(shape = 2, rate = 1),
                      algorithm_inference         = "optimizing")

post_mortality_summary <- posterior_mortality(object = igbm_fit,
                                              y_data = age_specific_mortality_counts)

# Visualise the posterior distribution of the mortality counts:
plot_posterior_mortality(post_mortality_summary, type = "age-specific")
plot_posterior_mortality(post_mortality_summary, type = "aggregated")
}
}
\references{
Bouranis, L., Demiris, N. Kalogeropoulos, K. and Ntzoufras, I. (2022). Bayesian analysis of diffusion-driven multi-type epidemic models with application to COVID-19. arXiv: \url{https://arxiv.org/abs/2211.15229}
}
