/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.smooth;

class GlobalSigmoidSmoothFunction {
    GlobalSigmoidSmoothFunction() {
    }

    public double getSmoothValue(double d, double d2, double d3, double d4, double d5) {
        double d6 = Math.exp(-d5 * (d - d2));
        return (d4 - d3) / (1.0 + d6) + d3;
    }

    public double getDerivative(double d, double d2, double d3, double d4, double d5) {
        double d6 = Math.exp(-d5 * (d - d2));
        double d7 = Double.isInfinite(d6) ? 0.0 : d5 * (d4 - d3) / (1.0 + 1.0 / d6) / (1.0 + d6);
        return d7;
    }

    public double getLogDerivative(double d, double d2, double d3, double d4, double d5) {
        double d6 = Math.exp(d5 * (d - d2));
        double d7 = Double.isInfinite(d6) ? 0.0 : d5 * (d4 - d3) / (d4 + d3 * d6) / (1.0 + d6);
        return d7;
    }

    public double getSingleIntegration(double d, double d2, double d3, double d4) {
        return (this.getLogOnePlusExponential(d2 - d3, d4) - this.getLogOnePlusExponential(d - d3, d4)) / d4;
    }

    public double getSingleIntegrationDerivative(double d, double d2, double d3, double d4) {
        double d5 = Math.exp(d4 * (d2 - d3));
        if (Double.isInfinite(d5)) {
            return -1.0;
        }
        return 1.0 / (1.0 + Math.exp(-d4 * (d - d3))) - d5 / (1.0 + d5);
    }

    public double getSingleIntegrationDerivativeWrtEndTime(double d, double d2, double d3) {
        double d4 = Math.exp(d3 * (d - d2));
        if (Double.isInfinite(d4)) {
            return 1.0;
        }
        return d4 / (1.0 + d4);
    }

    public double getQuadraticIntegration(double d, double d2, double d3, double d4) {
        return (this.getInverseOnePlusExponential(d2 - d3, d4) - this.getInverseOnePlusExponential(d - d3, d4) + this.getLogOnePlusExponential(d2 - d3, d4) - this.getLogOnePlusExponential(d - d3, d4)) / d4;
    }

    public double getPairProductIntegration(double d, double d2, double d3, double d4, double d5) {
        double d6 = d2 - d;
        double d7 = this.getInverseOneMinusExponential(d4 - d3, d5);
        double d8 = this.getInverseOneMinusExponential(d3 - d4, d5);
        return d6 + d7 * this.doubleProductSingleRatio(d, d2, d3, d5) + d8 * this.doubleProductSingleRatio(d, d2, d4, d5);
    }

    public double getPairProductIntegrationDerivativeWrtEndTime(double d, double d2, double d3, double d4, double d5) {
        double d6 = Math.exp(d5 * (d4 - d3));
        double d7 = 1.0 / (1.0 - Math.exp(d5 * (d4 - d3)));
        double d8 = 1.0 / (1.0 - Math.exp(d5 * (d3 - d4)));
        return 1.0 + d7 * this.doubleProductSingleRatioDerivativeWrtEndTime(d, d2, d3, d5) + d8 * this.doubleProductSingleRatioDerivativeWrtEndTime(d, d2, d4, d5);
    }

    public double getPairProductIntegrationDerivative(double d, double d2, double d3, double d4, double d5) {
        double d6 = Math.exp(d5 * (d4 - d3));
        double d7 = Math.exp(d5 * (d - d3));
        double d8 = Math.exp(d5 * (d2 - d3));
        double d9 = Double.isInfinite(d6) ? 0.0 : -d6 / ((1.0 - d6) * (1.0 - d6)) * (this.getLogOnePlusExponential(d3, d2, d5) - this.getLogOnePlusExponential(d3, d, d5));
        double d10 = 1.0 / (1.0 - d6) * (1.0 / (1.0 + d8) - 1.0 / (1.0 + d7));
        double d11 = Double.isInfinite(d6) ? 0.0 : d6 / ((1.0 - d6) * (1.0 - d6)) * (this.getLogOnePlusExponential(d4, d2, d5) - this.getLogOnePlusExponential(d4, d, d5));
        return d9 + d10 + d11;
    }

    private double getLogOnePlusExponential(double d, double d2, double d3) {
        double d4 = Math.exp(d3 * (d - d2));
        if (Double.isInfinite(d4)) {
            return d3 * (d - d2);
        }
        return Math.log(1.0 + Math.exp(d3 * (d - d2)));
    }

    private double doubleProductSingleRatio(double d, double d2, double d3, double d4) {
        double d5 = Math.exp(d4 * (d3 - d));
        double d6 = Math.log(1.0 + Math.exp(d4 * (d3 - d2))) / d4;
        if (Double.isInfinite(d5)) {
            return d6 - (d3 - d);
        }
        return d6 - Math.log(1.0 + d5) / d4;
    }

    private double doubleProductSingleRatioDerivativeWrtEndTime(double d, double d2, double d3, double d4) {
        double d5 = Math.exp(d4 * (d3 - d2));
        if (Double.isInfinite(d5)) {
            return -1.0;
        }
        return -d5 / (1.0 + d5);
    }

    public double getInverseOneMinusExponential(double d, double d2) {
        double d3 = Math.exp(d2 * d);
        if (Double.isInfinite(d3)) {
            return 0.0;
        }
        return 1.0 / (1.0 - d3);
    }

    public double getInverseOnePlusExponential(double d, double d2) {
        double d3 = Math.exp(d2 * d);
        if (Double.isInfinite(d3)) {
            return 0.0;
        }
        return 1.0 / (1.0 + d3);
    }

    public double getLogOnePlusExponential(double d, double d2) {
        double d3 = Math.exp(d2 * d);
        if (Double.isInfinite(d3)) {
            return d2 * d;
        }
        return Math.log(1.0 + d3);
    }

    public double getTripleProductIntegration(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = (this.getInverseOneMinusExponential(d4 - d3, d6) * this.getInverseOneMinusExponential(d5 - d3, d6) * (this.getLogOnePlusExponential(d3 - d2, d6) - this.getLogOnePlusExponential(d3 - d, d6)) + this.getInverseOneMinusExponential(d5 - d4, d6) * this.getInverseOneMinusExponential(d3 - d4, d6) * (this.getLogOnePlusExponential(d4 - d2, d6) - this.getLogOnePlusExponential(d4 - d, d6)) + this.getInverseOneMinusExponential(d3 - d5, d6) * this.getInverseOneMinusExponential(d4 - d5, d6) * (this.getLogOnePlusExponential(d5 - d2, d6) - this.getLogOnePlusExponential(d5 - d, d6))) / d6 + d2 - d;
        return d7;
    }

    public double getTripleProductWithQuadraticIntegration(double d, double d2, double d3, double d4, double d5) {
        double d6 = d2 - d;
        double d7 = this.getInverseOneMinusExponential(d4 - d3, d5) * (this.getInverseOnePlusExponential(d3 - d, d5) - this.getInverseOnePlusExponential(d3 - d2, d5));
        double d8 = (2.0 - this.getInverseOneMinusExponential(d4 - d3, d5)) * this.getInverseOneMinusExponential(d4 - d3, d5);
        double d9 = d8 * (this.getLogOnePlusExponential(d3 - d2, d5) - this.getLogOnePlusExponential(d3 - d, d5));
        double d10 = this.getInverseOneMinusExponential(d3 - d4, d5) * this.getInverseOneMinusExponential(d3 - d4, d5);
        double d11 = d10 * (this.getLogOnePlusExponential(d4 - d2, d5) - this.getLogOnePlusExponential(d4 - d, d5));
        return d6 + (d7 + d9 + d11) / d5;
    }
}

