/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.continuous;

import dr.evolution.continuous.Contrastable;

public class Continuous
implements Contrastable {
    private double value;

    public Continuous(double d) {
        this.value = d;
    }

    @Override
    public double getDifference(Contrastable contrastable) {
        if (contrastable instanceof Continuous) {
            return this.value - ((Continuous)contrastable).value;
        }
        throw new IllegalArgumentException("Expected a continuous parameter");
    }

    @Override
    public Contrastable getWeightedMean(double d, Contrastable contrastable, double d2, Contrastable contrastable2) {
        double d3 = 0.0;
        d3 += ((Continuous)contrastable).value * d;
        d3 += ((Continuous)contrastable2).value * d2;
        return new Continuous(d3 /= d + d2);
    }

    public double getValue() {
        return this.value;
    }

    public String toString() {
        return "" + this.getValue();
    }
}

