/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel.aminoacid;

import dr.evomodel.substmodel.EmpiricalRateMatrix;
import dr.evomodel.substmodel.aminoacid.Blosum62;
import dr.evomodel.substmodel.aminoacid.CPREV;
import dr.evomodel.substmodel.aminoacid.Dayhoff;
import dr.evomodel.substmodel.aminoacid.FLU;
import dr.evomodel.substmodel.aminoacid.JTT;
import dr.evomodel.substmodel.aminoacid.LG;
import dr.evomodel.substmodel.aminoacid.MTREV;
import dr.evomodel.substmodel.aminoacid.WAG;
import dr.util.Citation;

public enum AminoAcidModelType {
    BLOSUM_62("Blosum62", "blosum62", Blosum62.INSTANCE),
    DAYHOFF("Dayhoff", "dayhoff", Dayhoff.INSTANCE),
    JTT("JTT", dr.evomodel.substmodel.aminoacid.JTT.INSTANCE),
    MT_REV_24("mtREV", MTREV.INSTANCE),
    CP_REV_45("cpREV", CPREV.INSTANCE),
    WAG("WAG", dr.evomodel.substmodel.aminoacid.WAG.INSTANCE),
    LG("LG", dr.evomodel.substmodel.aminoacid.LG.INSTANCE),
    FLU("FLU", dr.evomodel.substmodel.aminoacid.FLU.INSTANCE);

    private final String displayName;
    private final String xmlName;
    private final EmpiricalRateMatrix matrix;

    private AminoAcidModelType(String string2, EmpiricalRateMatrix empiricalRateMatrix) {
        this(string2, string2, empiricalRateMatrix);
    }

    private AminoAcidModelType(String string2, String string3, EmpiricalRateMatrix empiricalRateMatrix) {
        this.displayName = string2;
        this.xmlName = string3;
        this.matrix = empiricalRateMatrix;
    }

    public String toString() {
        return this.displayName;
    }

    public String getXMLName() {
        return this.xmlName;
    }

    public EmpiricalRateMatrix getRateMatrixInstance() {
        return this.matrix;
    }

    public Citation getCitation() {
        return this.matrix.getCitations().get(0);
    }

    public static String[] xmlNames() {
        AminoAcidModelType[] aminoAcidModelTypeArray = AminoAcidModelType.values();
        String[] stringArray = new String[aminoAcidModelTypeArray.length];
        for (int i = 0; i < aminoAcidModelTypeArray.length; ++i) {
            stringArray[i] = aminoAcidModelTypeArray[i].getXMLName();
        }
        return stringArray;
    }
}

