/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.MutableTree;
import dr.evolution.tree.NodeRef;
import dr.evomodel.operators.AbstractTreeOperator;
import dr.evomodel.tree.TreeModel;
import dr.math.MathUtils;

@Deprecated
public class TreeUniform
extends AbstractTreeOperator {
    private final int nodesToMove;
    private final TreeModel tree;

    public TreeUniform(int n, TreeModel treeModel, double d) {
        assert (n == 2 || n == 3);
        this.tree = treeModel;
        this.nodesToMove = n;
        this.setWeight(d);
    }

    @Override
    public double doOperation() {
        if (this.tree.getInternalNodeCount() < 2) {
            throw new RuntimeException("no node found");
        }
        this.tree.beginTreeEdit();
        switch (this.nodesToMove) {
            case 2: {
                this.move2();
                break;
            }
            case 3: {
                this.move3();
            }
        }
        this.tree.endTreeEdit();
        try {
            this.tree.checkTreeIsValid();
        }
        catch (MutableTree.InvalidTreeException invalidTreeException) {
            throw new RuntimeException(invalidTreeException.toString());
        }
        return 0.0;
    }

    private void sorted(double[] dArray, int n, int n2) {
        if (dArray[n] < dArray[n2]) {
            this.exch(dArray, n, n2);
        }
    }

    private void exch(double[] dArray, int n, int n2) {
        double d = dArray[n];
        dArray[n] = dArray[n2];
        dArray[n2] = d;
    }

    private void move3() {
        int n;
        NodeRef nodeRef;
        int n2 = this.tree.getInternalNodeCount();
        NodeRef nodeRef2 = nodeRef = this.tree.getRoot();
        boolean bl = false;
        while (nodeRef == nodeRef2) {
            nodeRef2 = this.tree.getInternalNode(MathUtils.nextInt(n2));
        }
        boolean bl2 = this.tree.isExternal(this.tree.getChild(nodeRef2, 0));
        boolean bl3 = this.tree.isExternal(this.tree.getChild(nodeRef2, 1));
        if (bl2 || bl3) {
            if (bl2 != bl3) {
                this.doMove2(this.tree.getChild(nodeRef2, bl2 ? 1 : 0));
            } else {
                this.doMove1(nodeRef2);
            }
            return;
        }
        NodeRef nodeRef3 = this.tree.getParent(nodeRef2);
        NodeRef nodeRef4 = this.tree.getChild(nodeRef2, 0);
        NodeRef nodeRef5 = this.tree.getChild(nodeRef2, 1);
        double d = this.getMaxChildHeight(nodeRef4);
        double d2 = this.getMaxChildHeight(nodeRef5);
        double d3 = this.tree.getNodeHeight(nodeRef3);
        double d4 = Math.max(d, d2);
        double d5 = Math.min(d, d2);
        double d6 = d3 - d4;
        double d7 = Math.abs(d - d2) / 2.0;
        double d8 = d6 / 3.0;
        double d9 = d7 / (d7 + d8);
        double[] dArray = new double[3];
        int n3 = d < d2 ? 0 : 1;
        for (n = 0; n < 3; ++n) {
            dArray[n] = MathUtils.uniform(d4, d3);
        }
        if (MathUtils.nextDouble() < d9) {
            dArray[1 + n3] = MathUtils.uniform(d5, d4);
            this.sorted(dArray, 0, 2 - n3);
        } else {
            n = dArray[0] > dArray[1] ? 0 : 1;
            n = dArray[n] < dArray[2] ? 2 : n;
            this.exch(dArray, 0, n);
        }
        assert (d3 > dArray[0] && dArray[0] > dArray[1] && dArray[0] > dArray[2] && dArray[1] > d && dArray[2] > d2);
        NodeRef[] nodeRefArray = new NodeRef[]{nodeRef2, nodeRef4, nodeRef5};
        for (int i = 0; i < nodeRefArray.length; ++i) {
            this.tree.setNodeHeight(nodeRefArray[i], dArray[i]);
            this.tree.pushTreeChangedEvent(nodeRefArray[i]);
        }
    }

    private void move2() {
        NodeRef nodeRef;
        int n = this.tree.getInternalNodeCount();
        NodeRef nodeRef2 = nodeRef = this.tree.getRoot();
        while (nodeRef == nodeRef2) {
            nodeRef2 = this.tree.getInternalNode(MathUtils.nextInt(n));
        }
        this.doMove2(nodeRef2);
    }

    private void doMove2(NodeRef nodeRef) {
        NodeRef nodeRef2 = this.tree.getParent(nodeRef);
        if (nodeRef2 == this.tree.getRoot()) {
            this.doMove1(nodeRef);
            return;
        }
        NodeRef nodeRef3 = this.tree.getParent(nodeRef2);
        double d = this.getMaxChildHeight(nodeRef);
        double d2 = this.tree.getNodeHeight(nodeRef3);
        double d3 = Math.max(d, this.tree.getNodeHeight(this.getOtherChild(nodeRef2, nodeRef)));
        double d4 = d2 - d3;
        double d5 = d3 - d;
        double d6 = d4 / 2.0;
        double d7 = d5 / (d5 + d6);
        double[] dArray = new double[2];
        if (MathUtils.nextDouble() < d7) {
            dArray[0] = MathUtils.uniform(d, d3);
            dArray[1] = MathUtils.uniform(d3, d2);
        } else {
            for (int i = 0; i < 2; ++i) {
                dArray[i] = MathUtils.uniform(d3, d2);
            }
            if (dArray[0] > dArray[1]) {
                double d8 = dArray[0];
                dArray[0] = dArray[1];
                dArray[1] = d8;
            }
        }
        this.tree.setNodeHeight(nodeRef2, dArray[1]);
        this.tree.setNodeHeight(nodeRef, dArray[0]);
        this.tree.pushTreeChangedEvent(nodeRef2);
        this.tree.pushTreeChangedEvent(nodeRef);
    }

    private void doMove1(NodeRef nodeRef) {
        NodeRef nodeRef2 = this.tree.getParent(nodeRef);
        double d = this.tree.getNodeHeight(nodeRef2);
        double d2 = this.getMaxChildHeight(nodeRef);
        double d3 = MathUtils.uniform(d2, d);
        this.tree.setNodeHeight(nodeRef, d3);
        this.tree.pushTreeChangedEvent(nodeRef);
    }

    private NodeRef getOtherChild(NodeRef nodeRef, NodeRef nodeRef2) {
        for (int i = 0; i < this.tree.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef3 = this.tree.getChild(nodeRef, i);
            if (nodeRef3 == nodeRef2) continue;
            return nodeRef3;
        }
        return null;
    }

    private double getMaxChildHeight(NodeRef nodeRef) {
        double d = -1.0;
        for (int i = 0; i < this.tree.getChildCount(nodeRef); ++i) {
            d = Math.max(d, this.tree.getNodeHeight(this.tree.getChild(nodeRef, i)));
        }
        return d;
    }

    public String getPerformanceSuggestion() {
        return "";
    }

    @Override
    public String getOperatorName() {
        return "treeUniform(" + this.nodesToMove + "," + this.tree.getId() + ")";
    }
}

