/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evolution.coalescent.IntervalList;
import dr.evolution.coalescent.IntervalType;
import dr.evomodel.coalescent.AbstractCoalescentLikelihood;
import dr.evomodel.coalescent.CoalescentIntervalProvider;
import dr.evomodel.coalescent.GMRFSkyrideLikelihood;
import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.model.Likelihood;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.SymmTridiagMatrix;
import no.uib.cipr.matrix.Vector;

public class GMRFSkygridLikelihood
extends GMRFSkyrideLikelihood
implements GradientWrtParameterProvider,
CoalescentIntervalProvider,
Citable {
    public static final boolean DEBUG = false;
    private final double cutOff;
    private final int numGridPoints;
    private final int oldFieldLength;
    private final int numTrees;
    private double[] numCoalEvents;
    private double[] storedNumCoalEvents;
    private double[] gridPoints;
    private final Parameter phiParameter;
    private final Parameter ploidyFactors;
    private double[] ploidySums;
    private double[] storedPloidySums;
    private final SkygridHelper skygridHelper;
    private final List<MatrixParameter> covariates;
    private final List<Parameter> beta;
    private final List<Parameter> covPrecParametersRecent;
    private final List<Parameter> covPrecParametersDistant;
    private List<SymmTridiagMatrix> weightMatricesForMissingCovRecent;
    private List<SymmTridiagMatrix> weightMatricesForMissingCovDistant;
    private int[] firstObservedIndex;
    private int[] lastObservedIndex;
    private int[] recIndices;
    private int[] distIndices;
    private double[] coalescentEventStatisticValues;
    private List<IntervalList> intervalsList;
    private static final boolean NEW_APPROACH = true;

    public GMRFSkygridLikelihood(List<IntervalList> list, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Parameter parameter5, MatrixParameter matrixParameter, boolean bl, double d, int n, Parameter parameter6, Parameter parameter7) {
        super("gmrfSkyrideLikelihood");
        this.addKeyword("skygrid");
        if (list.size() > 1) {
            this.addKeyword("multilocus");
        }
        this.popSizeParameter = parameter;
        this.groupSizeParameter = parameter2;
        this.precisionParameter = parameter3;
        this.lambdaParameter = parameter4;
        this.betaParameter = parameter5;
        this.dMatrix = matrixParameter;
        if (matrixParameter != null) {
            this.addVariable(matrixParameter);
        }
        this.timeAwareSmoothing = bl;
        this.cutOff = d;
        this.numGridPoints = n;
        this.phiParameter = parameter6;
        this.ploidyFactors = parameter7;
        this.setupGridPoints();
        this.addVariable(this.popSizeParameter);
        this.addVariable(this.precisionParameter);
        this.addVariable(this.lambdaParameter);
        if (this.betaParameter != null) {
            this.addVariable(this.betaParameter);
            this.skygridHelper = new SkygridCovariateHelper();
        } else {
            this.skygridHelper = new SkygridHelper();
        }
        if (this.phiParameter != null) {
            this.addVariable(this.phiParameter);
        }
        this.addVariable(this.ploidyFactors);
        this.intervalsList = list;
        for (IntervalList intervalList : list) {
            this.addModel((Model)((Object)intervalList));
        }
        this.numTrees = list.size();
        int n2 = this.getCorrectFieldLength();
        if (this.popSizeParameter.getDimension() <= 1) {
            this.popSizeParameter.setDimension(n2);
        }
        this.fieldLength = this.popSizeParameter.getDimension();
        if (n2 != this.fieldLength) {
            throw new IllegalArgumentException("Population size parameter should have length " + n2);
        }
        this.oldFieldLength = this.getCorrectOldFieldLength();
        if (this.ploidyFactors.getDimension() != list.size()) {
            throw new IllegalArgumentException("Ploidy factors parameter should have length " + list.size());
        }
        this.wrapSetupIntervals();
        this.coalescentIntervals = new double[this.oldFieldLength];
        this.storedCoalescentIntervals = new double[this.oldFieldLength];
        this.sufficientStatistics = new double[this.fieldLength];
        this.storedSufficientStatistics = new double[this.fieldLength];
        this.numCoalEvents = new double[this.fieldLength];
        this.storedNumCoalEvents = new double[this.fieldLength];
        this.ploidySums = new double[this.fieldLength];
        this.storedPloidySums = new double[this.fieldLength];
        this.setupGMRFWeights();
        this.setupSufficientStatistics();
        this.addStatistic(new AbstractCoalescentLikelihood.DeltaStatistic());
        this.initializationReport();
        if (this.groupSizeParameter != null) {
            for (int i = 0; i < this.groupSizeParameter.getDimension(); ++i) {
                this.groupSizeParameter.setParameterValue(i, 1.0);
            }
        }
        this.coalescentEventStatisticValues = new double[this.getNumberOfCoalescentEvents()];
        this.covariates = null;
        this.beta = null;
        this.covPrecParametersRecent = null;
        this.covPrecParametersDistant = null;
    }

    public GMRFSkygridLikelihood(List<IntervalList> list, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Parameter parameter5, MatrixParameter matrixParameter, boolean bl, Parameter parameter6, List<MatrixParameter> list2, Parameter parameter7, List<Parameter> list3, List<Parameter> list4, List<Parameter> list5, List<Parameter> list6, Parameter parameter8, Parameter parameter9, List<Parameter> list7) {
        super("gmrfSkyrideLikelihood");
        int n;
        this.addKeyword("skygrid");
        if (list.size() > 1) {
            this.addKeyword("multilocus");
        }
        this.gridPoints = parameter6.getParameterValues();
        this.numGridPoints = this.gridPoints.length;
        this.cutOff = this.gridPoints[this.numGridPoints - 1];
        if (list3 != null) {
            this.firstObservedIndex = new int[list3.size()];
            for (n = 0; n < list3.size(); ++n) {
                this.firstObservedIndex[n] = (int)list3.get(n).getParameterValue(0);
            }
            if (parameter8 != null) {
                this.recIndices = new int[list3.size()];
                for (n = 0; n < list3.size(); ++n) {
                    this.recIndices[n] = (int)parameter8.getParameterValue(n);
                }
            } else {
                this.recIndices = new int[list3.size()];
                for (n = 0; n < list3.size(); ++n) {
                    this.recIndices[n] = n + 1;
                }
            }
        }
        if (list4 != null) {
            this.lastObservedIndex = new int[list4.size()];
            for (n = 0; n < list4.size(); ++n) {
                this.lastObservedIndex[n] = (int)list4.get(n).getParameterValue(0);
            }
            if (parameter9 != null) {
                this.distIndices = new int[list4.size()];
                for (n = 0; n < list4.size(); ++n) {
                    this.distIndices[n] = (int)parameter9.getParameterValue(n);
                }
            } else {
                this.distIndices = new int[list4.size()];
                for (n = 0; n < list4.size(); ++n) {
                    this.distIndices[n] = n + 1;
                }
            }
        }
        this.betaParameter = parameter5;
        if (parameter5 != null) {
            this.addVariable(parameter5);
        }
        this.popSizeParameter = parameter;
        this.groupSizeParameter = parameter2;
        this.precisionParameter = parameter3;
        this.lambdaParameter = parameter4;
        this.beta = list7;
        this.dMatrix = matrixParameter;
        if (matrixParameter != null) {
            this.addVariable(matrixParameter);
        }
        this.timeAwareSmoothing = bl;
        this.ploidyFactors = parameter7;
        this.covariates = list2;
        if (list2 != null) {
            for (MatrixParameter object : list2) {
                this.addVariable(object);
            }
        }
        this.covPrecParametersRecent = list5;
        if (list5 != null) {
            for (Parameter parameter10 : list5) {
                this.addVariable(parameter10);
            }
        }
        this.covPrecParametersDistant = list6;
        if (list6 != null) {
            for (Parameter parameter11 : list6) {
                this.addVariable(parameter11);
            }
        }
        this.addVariable(this.popSizeParameter);
        this.addVariable(this.precisionParameter);
        this.addVariable(this.lambdaParameter);
        this.addVariable(this.ploidyFactors);
        this.intervalsList = list;
        for (IntervalList intervalList : list) {
            this.addModel((Model)((Object)intervalList));
        }
        this.numTrees = list.size();
        int n2 = this.getCorrectFieldLength();
        if (this.popSizeParameter.getDimension() <= 1) {
            this.popSizeParameter.setDimension(n2);
        }
        this.fieldLength = this.popSizeParameter.getDimension();
        if (n2 != this.fieldLength) {
            throw new IllegalArgumentException("Population size parameter should have length " + n2);
        }
        this.oldFieldLength = this.getCorrectOldFieldLength();
        if (this.ploidyFactors.getDimension() != list.size()) {
            throw new IllegalArgumentException("Ploidy factor parameter should have length " + list.size());
        }
        if (list7 != null || parameter5 != null) {
            if (list7 != null) {
                for (Parameter parameter12 : list7) {
                    this.addVariable(parameter12);
                }
            }
            if (list4 != null || list3 != null) {
                this.setupGMRFWeightsForMissingCov();
                this.skygridHelper = new SkygridMissingCovariateHelper();
            } else {
                this.skygridHelper = new SkygridCovariateHelper();
            }
        } else {
            this.skygridHelper = new SkygridHelper();
        }
        this.wrapSetupIntervals();
        this.coalescentIntervals = new double[this.oldFieldLength];
        this.storedCoalescentIntervals = new double[this.oldFieldLength];
        this.sufficientStatistics = new double[this.fieldLength];
        this.storedSufficientStatistics = new double[this.fieldLength];
        this.numCoalEvents = new double[this.fieldLength];
        this.storedNumCoalEvents = new double[this.fieldLength];
        this.ploidySums = new double[this.fieldLength];
        this.storedPloidySums = new double[this.fieldLength];
        this.setupGMRFWeights();
        this.addStatistic(new AbstractCoalescentLikelihood.DeltaStatistic());
        this.initializationReport();
        this.phiParameter = null;
    }

    @Override
    protected int getCorrectFieldLength() {
        return this.numGridPoints + 1;
    }

    private int getCorrectOldFieldLength() {
        int n = 0;
        for (IntervalList intervalList : this.intervalsList) {
            n += intervalList.getSampleCount();
        }
        return n - this.intervalsList.size();
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model instanceof IntervalList) {
            IntervalList intervalList = (IntervalList)((Object)model);
            int n2 = this.intervalsList.indexOf(intervalList);
            if (n2 < 0) {
                throw new RuntimeException("Unknown tree modified in GMRFSkygridLikelihood");
            }
        } else {
            throw new RuntimeException("Unknown object modified in GMRFSkygridLikelihood");
        }
        this.intervalsKnown = false;
        this.likelihoodKnown = false;
    }

    @Override
    public void initializationReport() {
        System.out.println("Creating a GMRF smoothed skyride model for multiple loci (SkyGrid)");
        System.out.println("\tPopulation sizes: " + this.popSizeParameter.getDimension());
    }

    public void wrapSetupIntervals() {
    }

    private void setupGridPoints() {
        if (this.gridPoints == null) {
            this.gridPoints = new double[this.numGridPoints];
        } else {
            Arrays.fill(this.gridPoints, 0.0);
        }
        for (int i = 0; i < this.numGridPoints; ++i) {
            this.gridPoints[i] = (double)(i + 1) * (this.cutOff / (double)this.numGridPoints);
        }
    }

    @Override
    protected void setupSufficientStatistics() {
        Arrays.fill(this.numCoalEvents, 0.0);
        Arrays.fill(this.sufficientStatistics, 0.0);
        Arrays.fill(this.ploidySums, 0.0);
        for (int i = 0; i < this.numTrees; ++i) {
            int n;
            int n2;
            double d = 1.0 / this.getPopulationFactor(i);
            int n3 = 0;
            double d2 = this.intervalsList.get(i).getIntervalTime(n3);
            double d3 = this.intervalsList.get(i).getIntervalTime(n3 + 1);
            while (d3 <= d2) {
                d2 = this.intervalsList.get(i).getIntervalTime(++n3);
                d3 = this.intervalsList.get(i).getIntervalTime(n3 + 1);
            }
            int n4 = this.intervalsList.get(i).getLineageCount(n3);
            for (n2 = 0; n2 < this.numGridPoints - 1 && this.gridPoints[n2] <= d2; ++n2) {
            }
            int n5 = n2;
            double d4 = d2 + this.intervalsList.get(i).getTotalDuration();
            for (n = this.numGridPoints - 1; n >= 0 && this.gridPoints[n] >= d4; --n) {
            }
            if (n >= 0 && n2 < this.numGridPoints) {
                while (d3 < this.gridPoints[n5]) {
                    if (this.intervalsList.get(i).getCoalescentEvents(n3) > 0) {
                        int n6 = n5;
                        this.numCoalEvents[n6] = this.numCoalEvents[n6] + 1.0;
                    }
                    this.sufficientStatistics[n5] = this.sufficientStatistics[n5] + (d3 - d2) * (double)n4 * (double)(n4 - 1) * 0.5 * d;
                    d2 = d3;
                    d3 = this.intervalsList.get(i).getIntervalTime(++n3 + 1);
                    while (d3 <= d2) {
                        d2 = this.intervalsList.get(i).getIntervalTime(++n3);
                        d3 = this.intervalsList.get(i).getIntervalTime(n3 + 1);
                    }
                    n4 = this.intervalsList.get(i).getLineageCount(n3);
                }
                this.sufficientStatistics[n5] = this.sufficientStatistics[n5] + (this.gridPoints[n5] - d2) * (double)n4 * (double)(n4 - 1) * 0.5 * d;
                this.ploidySums[n5] = this.ploidySums[n5] + Math.log(d) * this.numCoalEvents[n5];
                ++n5;
                while (n5 <= n) {
                    if (d3 >= this.gridPoints[n5]) {
                        this.sufficientStatistics[n5] = this.sufficientStatistics[n5] + (this.gridPoints[n5] - this.gridPoints[n5 - 1]) * (double)n4 * (double)(n4 - 1) * 0.5 * d;
                        this.ploidySums[n5] = this.ploidySums[n5] + Math.log(d) * this.numCoalEvents[n5];
                        ++n5;
                        continue;
                    }
                    this.sufficientStatistics[n5] = this.sufficientStatistics[n5] + (d3 - this.gridPoints[n5 - 1]) * (double)n4 * (double)(n4 - 1) * 0.5 * d;
                    if (this.intervalsList.get(i).getCoalescentEvents(n3) > 0) {
                        int n7 = n5;
                        this.numCoalEvents[n7] = this.numCoalEvents[n7] + 1.0;
                    }
                    d2 = d3;
                    d3 = this.intervalsList.get(i).getIntervalTime(++n3 + 1);
                    while (d3 <= d2) {
                        d2 = this.intervalsList.get(i).getIntervalTime(++n3);
                        d3 = this.intervalsList.get(i).getIntervalTime(n3 + 1);
                    }
                    n4 = this.intervalsList.get(i).getLineageCount(n3);
                    while (d3 < this.gridPoints[n5]) {
                        if (this.intervalsList.get(i).getCoalescentEvents(n3) > 0) {
                            int n8 = n5;
                            this.numCoalEvents[n8] = this.numCoalEvents[n8] + 1.0;
                        }
                        this.sufficientStatistics[n5] = this.sufficientStatistics[n5] + (d3 - d2) * (double)n4 * (double)(n4 - 1) * 0.5 * d;
                        d2 = d3;
                        d3 = this.intervalsList.get(i).getIntervalTime(++n3 + 1);
                        while (d3 <= d2) {
                            d2 = this.intervalsList.get(i).getIntervalTime(++n3);
                            d3 = this.intervalsList.get(i).getIntervalTime(n3 + 1);
                        }
                        n4 = this.intervalsList.get(i).getLineageCount(n3);
                    }
                    this.sufficientStatistics[n5] = this.sufficientStatistics[n5] + (this.gridPoints[n5] - d2) * (double)n4 * (double)(n4 - 1) * 0.5 * d;
                    this.ploidySums[n5] = this.ploidySums[n5] + Math.log(d) * this.numCoalEvents[n5];
                    ++n5;
                }
                this.sufficientStatistics[n5] = this.sufficientStatistics[n5] + (d3 - this.gridPoints[n5 - 1]) * (double)n4 * (double)(n4 - 1) * 0.5 * d;
                if (this.intervalsList.get(i).getCoalescentEvents(n3) > 0) {
                    int n9 = n5;
                    this.numCoalEvents[n9] = this.numCoalEvents[n9] + 1.0;
                }
                d2 = d3;
                ++n3;
                while (n3 + 1 < this.intervalsList.get(i).getIntervalCount()) {
                    d3 = this.intervalsList.get(i).getIntervalTime(n3 + 1);
                    while (d3 <= d2) {
                        d2 = this.intervalsList.get(i).getIntervalTime(++n3);
                        d3 = this.intervalsList.get(i).getIntervalTime(n3 + 1);
                    }
                    n4 = this.intervalsList.get(i).getLineageCount(n3);
                    if (this.intervalsList.get(i).getCoalescentEvents(n3) > 0) {
                        int n10 = n5;
                        this.numCoalEvents[n10] = this.numCoalEvents[n10] + 1.0;
                    }
                    this.sufficientStatistics[n5] = this.sufficientStatistics[n5] + (d3 - d2) * (double)n4 * (double)(n4 - 1) * 0.5 * d;
                    d2 = d3;
                    ++n3;
                }
                continue;
            }
            while (n3 + 1 < this.intervalsList.get(i).getIntervalCount()) {
                if (this.intervalsList.get(i).getCoalescentEvents(n3) > 0) {
                    int n11 = n5;
                    this.numCoalEvents[n11] = this.numCoalEvents[n11] + 1.0;
                }
                this.sufficientStatistics[n5] = this.sufficientStatistics[n5] + (d3 - d2) * (double)n4 * (double)(n4 - 1) * 0.5 * d;
                d2 = d3;
                if (++n3 + 1 >= this.intervalsList.get(i).getIntervalCount()) continue;
                d3 = this.intervalsList.get(i).getIntervalTime(n3 + 1);
                while (d3 <= d2) {
                    d2 = this.intervalsList.get(i).getIntervalTime(++n3);
                    d3 = this.intervalsList.get(i).getIntervalTime(n3 + 1);
                }
                n4 = this.intervalsList.get(i).getLineageCount(n3);
            }
            this.ploidySums[n5] = this.ploidySums[n5] + Math.log(d) * this.numCoalEvents[n5];
        }
    }

    public double[] getNumCoalEvents() {
        return this.numCoalEvents;
    }

    @Override
    public int getNumberOfCoalescentEvents() {
        return this.getCorrectOldFieldLength();
    }

    @Override
    public double getCoalescentEventsStatisticValue(int n) {
        if (n == 0) {
            int n2;
            if (this.numTrees > 1) {
                throw new RuntimeException("Generalized stepping-stone sampling for the Skygrid not implemented for #trees > 1");
            }
            for (n2 = 0; n2 < this.coalescentEventStatisticValues.length; ++n2) {
                this.coalescentEventStatisticValues[n2] = 0.0;
            }
            n2 = 0;
            for (int i = 0; i < this.intervalsList.get(0).getIntervalCount(); ++i) {
                if (this.intervalsList.get(0).getIntervalType(i) == IntervalType.COALESCENT) {
                    int n3 = n2++;
                    this.coalescentEventStatisticValues[n3] = this.coalescentEventStatisticValues[n3] + this.intervalsList.get(0).getInterval(i) * ((double)this.intervalsList.get(0).getLineageCount(i) * ((double)this.intervalsList.get(0).getLineageCount(i) - 1.0)) / 2.0;
                    continue;
                }
                int n4 = n2;
                this.coalescentEventStatisticValues[n4] = this.coalescentEventStatisticValues[n4] + this.intervalsList.get(0).getInterval(i) * ((double)this.intervalsList.get(0).getLineageCount(i) * ((double)this.intervalsList.get(0).getLineageCount(i) - 1.0)) / 2.0;
            }
        }
        return this.coalescentEventStatisticValues[n];
    }

    @Override
    protected double calculateLogCoalescentLikelihood() {
        if (!this.intervalsKnown) {
            this.wrapSetupIntervals();
            for (IntervalList intervalList : this.intervalsList) {
                intervalList.calculateIntervals();
            }
            this.setupSufficientStatistics();
            this.intervalsKnown = true;
        }
        double d = 0.0;
        double[] dArray = this.popSizeParameter.getParameterValues();
        for (int i = 0; i < this.fieldLength; ++i) {
            d += -this.numCoalEvents[i] * dArray[i] + this.ploidySums[i] - this.sufficientStatistics[i] * Math.exp(-dArray[i]);
        }
        return d;
    }

    @Override
    public double calculateLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogCoalescentLikelihood();
            this.logFieldLikelihood = this.skygridHelper.getLogFieldLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood + this.logFieldLikelihood;
    }

    @Override
    protected void setupGMRFWeights() {
        int n;
        double[] dArray = new double[this.fieldLength - 1];
        double[] dArray2 = new double[this.fieldLength];
        double d = 2.0;
        for (n = 0; n < this.fieldLength - 1; ++n) {
            dArray[n] = -1.0;
        }
        for (n = 1; n < this.fieldLength - 1; ++n) {
            dArray2[n] = d;
        }
        dArray2[0] = d - 1.0;
        dArray2[this.fieldLength - 1] = d - 1.0;
        this.weightMatrix = new SymmTridiagMatrix(dArray2, dArray);
    }

    @Override
    protected double getFieldScalar() {
        return 1.0;
    }

    private void setupGMRFWeightsForMissingCov() {
        int n;
        double[] dArray;
        double[] dArray2;
        int n2;
        if (this.firstObservedIndex != null) {
            this.weightMatricesForMissingCovRecent = new ArrayList<SymmTridiagMatrix>();
            for (n2 = 0; n2 < this.covPrecParametersRecent.size(); ++n2) {
                dArray2 = new double[this.firstObservedIndex[n2] - 2];
                dArray = new double[this.firstObservedIndex[n2] - 1];
                for (n = 0; n < this.firstObservedIndex[n2] - 2; ++n) {
                    dArray2[n] = -1.0;
                }
                for (n = 1; n < this.firstObservedIndex[n2] - 1; ++n) {
                    dArray[n] = 2.0;
                }
                dArray[0] = 1.0;
                this.weightMatricesForMissingCovRecent.add(n2, new SymmTridiagMatrix(dArray, dArray2));
            }
        }
        if (this.lastObservedIndex != null) {
            this.weightMatricesForMissingCovDistant = new ArrayList<SymmTridiagMatrix>();
            for (n2 = 0; n2 < this.covPrecParametersDistant.size(); ++n2) {
                dArray2 = new double[this.fieldLength - this.lastObservedIndex[n2] - 1];
                dArray = new double[this.fieldLength - this.lastObservedIndex[n2]];
                for (n = 0; n < this.fieldLength - this.lastObservedIndex[n2] - 1; ++n) {
                    dArray2[n] = -1.0;
                }
                for (n = 0; n < this.fieldLength - this.lastObservedIndex[n2] - 1; ++n) {
                    dArray[n] = 2.0;
                }
                dArray[this.fieldLength - this.lastObservedIndex[n2] - 1] = 1.0;
                this.weightMatricesForMissingCovDistant.add(n2, new SymmTridiagMatrix(dArray, dArray2));
            }
        }
    }

    private SymmTridiagMatrix getScaledWeightMatrixForMissingCovRecent(double d, int n, int n2) {
        SymmTridiagMatrix symmTridiagMatrix = this.weightMatricesForMissingCovRecent.get(n).copy();
        for (int i = 0; i < symmTridiagMatrix.numRows() - 1; ++i) {
            symmTridiagMatrix.set(i, i, symmTridiagMatrix.get(i, i) * d);
            symmTridiagMatrix.set(i + 1, i, symmTridiagMatrix.get(i + 1, i) * d);
        }
        symmTridiagMatrix.set(n2 - 2, n2 - 2, symmTridiagMatrix.get(n2 - 2, n2 - 2) * d);
        return symmTridiagMatrix;
    }

    private SymmTridiagMatrix getScaledWeightMatrixForMissingCovDistant(double d, int n, int n2) {
        SymmTridiagMatrix symmTridiagMatrix = this.weightMatricesForMissingCovDistant.get(n).copy();
        for (int i = 0; i < symmTridiagMatrix.numRows() - 1; ++i) {
            symmTridiagMatrix.set(i, i, symmTridiagMatrix.get(i, i) * d);
            symmTridiagMatrix.set(i + 1, i, symmTridiagMatrix.get(i + 1, i) * d);
        }
        symmTridiagMatrix.set(this.fieldLength - n2 - 1, this.fieldLength - n2 - 1, symmTridiagMatrix.get(this.fieldLength - n2 - 1, this.fieldLength - n2 - 1) * d);
        return symmTridiagMatrix;
    }

    public int nLoci() {
        return this.intervalsList.size();
    }

    public double getPopulationFactor(int n) {
        return this.ploidyFactors.getParameterValue(n);
    }

    public List<Parameter> getBetaListParameter() {
        return this.beta;
    }

    public List<MatrixParameter> getCovariates() {
        return this.covariates;
    }

    @Override
    protected void storeState() {
        super.storeState();
        System.arraycopy(this.numCoalEvents, 0, this.storedNumCoalEvents, 0, this.numCoalEvents.length);
        System.arraycopy(this.ploidySums, 0, this.storedPloidySums, 0, this.ploidySums.length);
    }

    @Override
    protected void restoreState() {
        super.restoreState();
        double[] dArray = this.numCoalEvents;
        this.numCoalEvents = this.storedNumCoalEvents;
        this.storedNumCoalEvents = dArray;
        double[] dArray2 = this.ploidySums;
        this.ploidySums = this.storedPloidySums;
        this.storedPloidySums = dArray2;
    }

    @Override
    public Parameter getParameter() {
        return this.popSizeParameter;
    }

    @Override
    public int getDimension() {
        return this.popSizeParameter.getDimension();
    }

    @Override
    public Likelihood getLikelihood() {
        return this;
    }

    @Override
    public double[] getGradientLogDensity() {
        Parameter parameter;
        int n;
        double[] dArray = new double[this.popSizeParameter.getSize()];
        double[] dArray2 = this.popSizeParameter.getParameterValues();
        int n2 = this.popSizeParameter.getSize();
        dArray[0] = this.precisionParameter.getParameterValue(0) * (dArray2[0] - dArray2[1]) + this.numCoalEvents[0] - this.sufficientStatistics[0] * Math.exp(-dArray2[0]);
        dArray[n2 - 1] = this.precisionParameter.getParameterValue(0) * (dArray2[n2 - 1] - dArray2[n2 - 2]) + this.numCoalEvents[n2 - 1] - this.sufficientStatistics[n2 - 1] * Math.exp(-dArray2[n2 - 1]);
        if (this.beta != null) {
            for (n = 0; n < this.beta.size(); ++n) {
                Parameter parameter2 = this.beta.get(n);
                parameter = this.covariates.get(n);
                dArray[0] = dArray[0] - this.precisionParameter.getParameterValue(0) * ((MatrixParameter)parameter).getParameterValue(0, 0) * parameter2.getParameterValue(0) + this.precisionParameter.getParameterValue(0) * ((MatrixParameter)parameter).getParameterValue(0, 1) * parameter2.getParameterValue(0);
                dArray[n2 - 1] = dArray[n2 - 1] - this.precisionParameter.getParameterValue(0) * ((MatrixParameter)parameter).getParameterValue(0, n2 - 1) * parameter2.getParameterValue(0) + this.precisionParameter.getParameterValue(0) * ((MatrixParameter)parameter).getParameterValue(0, n2 - 2) * parameter2.getParameterValue(0);
            }
        }
        for (n = 1; n < n2 - 1; ++n) {
            dArray[n] = this.precisionParameter.getParameterValue(0) * (-dArray2[n - 1] + 2.0 * dArray2[n] - dArray2[n + 1]) + this.numCoalEvents[n] - this.sufficientStatistics[n] * Math.exp(-dArray2[n]);
            if (this.beta == null) continue;
            for (int i = 0; i < this.beta.size(); ++i) {
                parameter = this.beta.get(i);
                MatrixParameter matrixParameter = this.covariates.get(i);
                dArray[n] = dArray[n] + this.precisionParameter.getParameterValue(0) * matrixParameter.getParameterValue(0, n - 1) * parameter.getParameterValue(0) - 2.0 * this.precisionParameter.getParameterValue(0) * matrixParameter.getParameterValue(0, n) * parameter.getParameterValue(0) + this.precisionParameter.getParameterValue(0) * matrixParameter.getParameterValue(0, n + 1) * parameter.getParameterValue(0);
            }
        }
        return dArray;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TREE_PRIORS;
    }

    @Override
    public String getDescription() {
        return "Skyride coalescent";
    }

    @Override
    public List<Citation> getCitations() {
        return Arrays.asList(new Citation(new Author[]{new Author("MS", "Gill"), new Author("P", "Lemey"), new Author("NR", "Faria"), new Author("A", "Rambaut"), new Author("B", "Shapiro"), new Author("MA", "Suchard")}, "Improving Bayesian population dynamics inference: a coalescent-based model for multiple loci", 2013, "Mol Biol Evol", 30, 713, 724), new Citation(new Author[]{new Author("VN", "Minin"), new Author("EW", "Bloomquist"), new Author("MA", "Suchard")}, "Smooth skyride through a rough skyline: Bayesian coalescent-based inference of population dynamics", 2008, "Mol Biol Evol", 25, 1459, 1471, "10.1093/molbev/msn090"));
    }

    class SkygridMissingCovariateHelper
    extends SkygridCovariateHelper {
        SkygridMissingCovariateHelper() {
        }

        @Override
        protected double handleMissingValues() {
            int n;
            SymmTridiagMatrix symmTridiagMatrix;
            DenseVector denseVector;
            DenseVector denseVector2;
            int n2;
            assert (GMRFSkygridLikelihood.this.covPrecParametersRecent != null);
            assert (GMRFSkygridLikelihood.this.covariates != null);
            assert (GMRFSkygridLikelihood.this.covPrecParametersDistant != null);
            double d = 0.0;
            if (GMRFSkygridLikelihood.this.lastObservedIndex != null) {
                for (n2 = 0; n2 < GMRFSkygridLikelihood.this.covPrecParametersDistant.size(); ++n2) {
                    int n3 = GMRFSkygridLikelihood.this.fieldLength - GMRFSkygridLikelihood.this.lastObservedIndex[n2];
                    denseVector2 = new DenseVector(n3);
                    denseVector = new DenseVector(n3);
                    symmTridiagMatrix = GMRFSkygridLikelihood.this.getScaledWeightMatrixForMissingCovDistant(((Parameter)GMRFSkygridLikelihood.this.covPrecParametersDistant.get(n2)).getParameterValue(0), n2, GMRFSkygridLikelihood.this.lastObservedIndex[n2]);
                    for (n = 0; n < n3; ++n) {
                        denseVector2.set(n, ((MatrixParameter)GMRFSkygridLikelihood.this.covariates.get(GMRFSkygridLikelihood.this.distIndices[n2] - 1)).getParameterValue(0, GMRFSkygridLikelihood.this.lastObservedIndex[n2] + n) - ((MatrixParameter)GMRFSkygridLikelihood.this.covariates.get(GMRFSkygridLikelihood.this.distIndices[n2] - 1)).getParameterValue(0, GMRFSkygridLikelihood.this.lastObservedIndex[n2] - 1));
                    }
                    symmTridiagMatrix.mult(denseVector2, denseVector);
                    d += 0.5 * (double)n3 * Math.log(((Parameter)GMRFSkygridLikelihood.this.covPrecParametersDistant.get(n2)).getParameterValue(0)) - 0.5 * denseVector2.dot(denseVector);
                }
            }
            if (GMRFSkygridLikelihood.this.firstObservedIndex != null) {
                for (n2 = 0; n2 < GMRFSkygridLikelihood.this.covPrecParametersRecent.size(); ++n2) {
                    int n4 = GMRFSkygridLikelihood.this.firstObservedIndex[n2] - 1;
                    denseVector2 = new DenseVector(n4);
                    denseVector = new DenseVector(n4);
                    symmTridiagMatrix = GMRFSkygridLikelihood.this.getScaledWeightMatrixForMissingCovRecent(((Parameter)GMRFSkygridLikelihood.this.covPrecParametersRecent.get(n2)).getParameterValue(0), n2, GMRFSkygridLikelihood.this.firstObservedIndex[n2]);
                    for (n = 0; n < n4; ++n) {
                        denseVector2.set(n, ((MatrixParameter)GMRFSkygridLikelihood.this.covariates.get(GMRFSkygridLikelihood.this.recIndices[n2] - 1)).getParameterValue(0, n) - ((MatrixParameter)GMRFSkygridLikelihood.this.covariates.get(GMRFSkygridLikelihood.this.recIndices[n2] - 1)).getParameterValue(0, GMRFSkygridLikelihood.this.firstObservedIndex[n2] - 1));
                    }
                    symmTridiagMatrix.mult(denseVector2, denseVector);
                    d += 0.5 * (double)n4 * Math.log(((Parameter)GMRFSkygridLikelihood.this.covPrecParametersRecent.get(n2)).getParameterValue(0)) - 0.5 * denseVector2.dot(denseVector);
                }
            }
            return d;
        }
    }

    class SkygridCovariateHelper
    extends SkygridHelper {
        SkygridCovariateHelper() {
        }

        @Override
        protected void updateGammaWithCovariates(DenseVector denseVector) {
            int n;
            int n2;
            assert (GMRFSkygridLikelihood.this.beta != null);
            int n3 = denseVector.size();
            double[] dArray = new double[n3];
            if (GMRFSkygridLikelihood.this.dMatrix != null) {
                n2 = GMRFSkygridLikelihood.this.dMatrix.getColumnDimension();
                if (n3 != GMRFSkygridLikelihood.this.dMatrix.getRowDimension()) {
                    throw new RuntimeException("Incorrect covariate dimensions (" + n3 + " != " + GMRFSkygridLikelihood.this.dMatrix.getRowDimension() + ")");
                }
                for (int i = 0; i < n3; ++i) {
                    for (n = 0; n < n2; ++n) {
                        int n4 = i;
                        dArray[n4] = dArray[n4] + GMRFSkygridLikelihood.this.dMatrix.getParameterValue(i, n) * GMRFSkygridLikelihood.this.betaParameter.getParameterValue(n);
                    }
                }
            }
            if (GMRFSkygridLikelihood.this.covariates != null) {
                if (GMRFSkygridLikelihood.this.beta.size() != GMRFSkygridLikelihood.this.covariates.size()) {
                    throw new RuntimeException("beta.size(" + GMRFSkygridLikelihood.this.beta.size() + ") != covariates.size(" + GMRFSkygridLikelihood.this.covariates.size() + ")");
                }
                for (n2 = 0; n2 < GMRFSkygridLikelihood.this.beta.size(); ++n2) {
                    MatrixParameter matrixParameter;
                    Parameter parameter = (Parameter)GMRFSkygridLikelihood.this.beta.get(n2);
                    n = parameter.getDimension();
                    if (n != (matrixParameter = (MatrixParameter)GMRFSkygridLikelihood.this.covariates.get(n2)).getRowDimension() || n3 != matrixParameter.getColumnDimension()) {
                        throw new RuntimeException("Incorrect dimensions in " + matrixParameter.getId() + " (r=" + matrixParameter.getRowDimension() + ",c=" + matrixParameter.getColumnDimension() + ")");
                    }
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n; ++j) {
                            int n5 = i;
                            dArray[n5] = dArray[n5] + matrixParameter.getParameterValue(j, i) * parameter.getParameterValue(j);
                        }
                    }
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                denseVector.set(n2, denseVector.get(n2) - dArray[n2]);
            }
        }
    }

    class SkygridHelper {
        SkygridHelper() {
        }

        void updateGammaWithCovariates(DenseVector denseVector) {
        }

        double handleMissingValues() {
            return 0.0;
        }

        double getLogFieldLikelihood() {
            Object object2;
            if (!GMRFSkygridLikelihood.this.intervalsKnown) {
                GMRFSkygridLikelihood.this.wrapSetupIntervals();
                for (Object object2 : GMRFSkygridLikelihood.this.intervalsList) {
                    object2.calculateIntervals();
                }
                GMRFSkygridLikelihood.this.setupSufficientStatistics();
                GMRFSkygridLikelihood.this.intervalsKnown = true;
            }
            DenseVector denseVector = new DenseVector(GMRFSkygridLikelihood.this.fieldLength);
            object2 = new DenseVector(GMRFSkygridLikelihood.this.popSizeParameter.getParameterValues());
            this.updateGammaWithCovariates((DenseVector)object2);
            double d = this.handleMissingValues();
            SymmTridiagMatrix symmTridiagMatrix = GMRFSkygridLikelihood.this.getScaledWeightMatrix(GMRFSkygridLikelihood.this.precisionParameter.getParameterValue(0), GMRFSkygridLikelihood.this.lambdaParameter.getParameterValue(0));
            symmTridiagMatrix.mult((Vector)object2, denseVector);
            d += 0.5 * (double)(GMRFSkygridLikelihood.this.fieldLength - 1) * Math.log(GMRFSkygridLikelihood.this.precisionParameter.getParameterValue(0)) - 0.5 * ((DenseVector)object2).dot(denseVector);
            d = GMRFSkygridLikelihood.this.lambdaParameter.getParameterValue(0) == 1.0 ? (d -= (double)(GMRFSkygridLikelihood.this.fieldLength - 1) / 2.0 * 1.837877) : (d -= (double)GMRFSkygridLikelihood.this.fieldLength / 2.0 * 1.837877);
            return d;
        }
    }
}

