% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AbsorbEvidence.R
\name{AbsorbEvidence}
\alias{AbsorbEvidence}
\title{Absorb evidence into the model}
\usage{
AbsorbEvidence(tree, vars, values)
}
\arguments{
\item{tree}{a \code{clustertree} object}

\item{vars}{a \code{vector} of the names of observed variables}

\item{values}{a \code{list} of observed values of the variables. Aside from a single value,
The element of the list can also be a vector of likelihood values}
}
\value{
\code{clustertree} object with the evidence absorbed
}
\description{
Absorb evidence into the model
}
\details{
Absorb multiple types and pieces of evidences into a \code{clustertree}
object. The discrete compartment of the \code{clustertree} will be automatically
propagated after evidence absorption, so that the object will be ready for making
queries and absorbing additional evidence.
}
\examples{

data(liver)
cst <- ClusterTreeCompile(dag=liver$dag, node.class=liver$node.class)
models <- LocalModelCompile(data=liver$data, dag=liver$dag, node.class=liver$node.class)
tree.init <- ElimTreeInitialize(tree=cst$tree.graph, 
                                dag=cst$dag, 
                                model=models, 
                                node.sets=cst$cluster.sets, 
                                node.class=cst$node.class)
tree.init.p <- PropagateDBN(tree.init)
tree.post <- AbsorbEvidence(tree.init.p, c("Nr1i3", "chr1_42.65"), list(1,"1"))

}
\author{
Han Yu
}
\references{
Cowell, R. G. (2005). Local propagation in conditional Gaussian Bayesian networks. 
Journal of Machine Learning Research, 6(Sep), 1517-1550. \cr
\cr
Lauritzen, S. L., & Spiegelhalter, D. J. (1988). Local computations with probabilities on 
graphical structures and their application to expert systems. Journal of the Royal Statistical 
Society. Series B (Methodological), 157-224.
}
\seealso{
\code{\link{clustertree}}
}

