% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dev_ermod_lin.R
\name{dev_ermod_bin_exp_sel}
\alias{dev_ermod_bin_exp_sel}
\alias{dev_ermod_lin_exp_sel}
\title{Exposure metrics selection for linear ER models}
\usage{
dev_ermod_bin_exp_sel(
  data,
  var_resp,
  var_exp_candidates,
  prior = rstanarm::default_prior_coef(stats::binomial()),
  prior_intercept = rstanarm::default_prior_intercept(stats::binomial()),
  verbosity_level = 1,
  chains = 4,
  iter = 2000
)

dev_ermod_lin_exp_sel(
  data,
  var_resp,
  var_exp_candidates,
  prior = rstanarm::default_prior_coef(stats::binomial()),
  prior_intercept = rstanarm::default_prior_intercept(stats::binomial()),
  prior_aux = rstanarm::exponential(autoscale = TRUE),
  verbosity_level = 1,
  chains = 4,
  iter = 2000
)
}
\arguments{
\item{data}{Input data for E-R analysis}

\item{var_resp}{Response variable name in character}

\item{var_exp_candidates}{Candidate exposure variable names
in character vector}

\item{prior, prior_intercept, prior_aux}{See \code{\link[rstanarm:stan_glm]{rstanarm::stan_glm()}}}

\item{verbosity_level}{Verbosity level. 0: No output, 1: Display steps,
2: Display progress in each step, 3: Display MCMC sampling.}

\item{chains}{Number of chains for Stan.}

\item{iter}{Number of iterations for Stan.}
}
\value{
An object of class \code{ermod_bin_exp_sel}.or \code{ermod_lin_exp_sel}
}
\description{
This functions is used to develop an linear ER model with binary
and continuous endpoint, using various exposure metrics and
selecting the best one.
}
\examples{
\donttest{
data(d_sim_binom_cov_hgly2)

ermod_bin_exp_sel <-
  dev_ermod_bin_exp_sel(
    data = d_sim_binom_cov_hgly2,
    var_resp = "AEFLAG",
    var_exp_candidates = c("AUCss_1000", "Cmaxss", "Cminss")
  )

ermod_bin_exp_sel
}

\donttest{
data(d_sim_lin)

ermod_lin_exp_sel <- dev_ermod_lin_exp_sel(
  data = d_sim_lin,
  var_resp = "response",
  var_exp_candidates = c("AUCss", "Cmaxss")
)

ermod_lin_exp_sel
}

}
