% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/class_functions.R
\name{set.to.class}
\alias{set.to.class}
\title{Building of model classes}
\usage{
set.to.class(class.name = c("jumpDiffusion", "Merton", "Diffusion",
  "mixedDiffusion", "hiddenDiffusion", "hiddenmixedDiffusion", "jumpRegression",
  "NHPP", "Regression", "mixedRegression"), parameter, prior, start, b.fun,
  s.fun, h.fun, sT.fun, y0.fun, fun, Lambda, priorDensity)
}
\arguments{
\item{class.name}{name of model class}

\item{parameter}{list of parameter values}

\item{prior}{optional list of prior parameters}

\item{start}{optional list of starting values}

\item{b.fun}{drift function b}

\item{s.fun}{variance function s}

\item{h.fun}{jump high function h}

\item{sT.fun}{variance function \eqn{\widetilde{s}}}

\item{y0.fun}{function for the starting point, if dependent on parameter}

\item{fun}{regression function}

\item{Lambda}{intensity rate of Poisson process}

\item{priorDensity}{list of functions for prior densities, if missing: non-informative estimation}
}
\description{
Definition of the model classes.
}
\section{Details}{

\code{set.to.class} is the central function to define a S4 model class, where the \code{simulate} and the \code{estimate} methods build up.
Main input parameter is \code{class.name}, which is one out of "jumpDiffusion", "Merton", "Diffusion", "mixedDiffusion", "hiddenDiffusion", "hiddenmixedDiffusion", "jumpRegression", "NHPP", "Regression" and "mixedRegression",
which is the name of the class object containing all information of the model.
If you write \code{set.to.class(class.name)} without any further input parameter, the function tells you which entries the list \code{parameter} has to contain.
This is the second central input parameter. If input parameter \code{start} is missing, it is set to \code{parameters}.
If input parameter \code{prior}, which is a list of prior parameters, is missing, they are calculated from \code{parameter} in that way, that prior mean and standard deviation is equal to the entries of \code{parameter}.
Functions \code{b.fun, s.fun, h.fun} can be seen in the model definition of the jump diffusion \eqn{dY_t = b(\phi, t, Y_t)dt + s(\gamma^2, t, Y_t)dW_t + h(\theta, t, Y_t)dN_t}.
In the case of a continuous diffusion, one out of "Diffusion", "mixedDiffusion", "hiddenDiffusion" or "hiddenmixedDiffusion", variance function \eqn{s(\gamma^2, t, y)} is restricted to the case \eqn{s(\gamma^2, t, y)=\gamma\widetilde{s}(t, y)}. \code{sT.fun} stands for \eqn{\widetilde{s}(t, y)}.
In the case of a regression model, "Regression" or "mixedRegression", \code{sT.fun} means the variance function dependent on t of the regression error \eqn{\epsilon_i\sim N(0,\sigma^2\widetilde{s}(t))}.
In both cases, default value is \code{sT.fun = function(t, y) 1}.
\code{y0.fun} is for the models, where the starting value depends on the parameter phi, "mixedDiffusion", "hiddenDiffusion" or "hiddenmixedDiffusion". Default value is a constant function in 1.
\code{fun} is the regression function for the models "Regression", "mixedRegression" and "jumpRegression". In the first two cases, this is \eqn{f(\phi, t)} and in the third \eqn{f(t, N_t, \theta)}.
Function \code{Lambda} is the cumulative intensity function in the models including the non-homogeneous Poisson process.
Input parameter \code{priorDensity} is for the model class \code{\link{jumpDiffusion-class}} a list of functions for the prior density functions.
For the model classes \code{\link{NHPP-class}} and \code{\link{Merton-class}}, \code{priorDensity} is the density of the intensity rate parameter of the Poisson process.
Default is a non-informative approach for all cases.
}
\examples{
set.to.class("jumpDiffusion")
(names <- set.to.class("jumpDiffusion"))
model <- set.to.class("jumpDiffusion",
             parameter = list(theta = 0.1, phi = 0.01, gamma2 = 0.1, xi = 3))
summary(class.to.list(model))
}

