% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/estimate.R
\docType{methods}
\name{estimate,mixedDiffusion-method}
\alias{estimate,mixedDiffusion-method}
\title{Estimation for hierarchical (mixed) diffusion model}
\usage{
\S4method{estimate}{mixedDiffusion}(model.class, t, data, nMCMC, propSd,
  adapt = TRUE, proposal = c("normal", "lognormal"))
}
\arguments{
\item{model.class}{class of the hierarchical diffusion model including all required information, see \code{\link{mixedDiffusion-class}}}

\item{t}{list or vector of time points}

\item{data}{list or matrix of observation variables}

\item{nMCMC}{length of Markov chain}

\item{propSd}{vector of proposal variances for \eqn{\phi}}

\item{adapt}{if TRUE (default), proposal variance is adapted}

\item{proposal}{proposal density: "normal" (default) or "lognormal" (for positive parameters)}
}
\description{
Bayesian estimation of a model
\eqn{dY_t = b(\phi_j,t,Y_t)dt + \gamma \widetilde{s}(t,Y_t)dW_t, \phi_j\sim N(\mu, \Omega), Y_{t_0}=y_0(\phi, t_0)}.
}
\examples{
mu <- 2; Omega <- 0.4; phi <- matrix(rnorm(21, mu, sqrt(Omega)))
model <- set.to.class("mixedDiffusion",
             parameter = list(phi = phi, mu = mu, Omega = Omega, gamma2 = 0.1),
             b.fun = function(phi, t, x) phi*x, sT.fun = function(t, x) x)
t <- seq(0, 1, by = 0.01)
data <- simulate(model, t = t, plot.series = TRUE)
est <- estimate(model, t, data[1:20,], 100)  # nMCMC should be much larger
plot(est)

# OU
b.fun <- function(phi, t, y) phi[1]-phi[2]*y; y0.fun <- function(phi, t) phi[3]
mu <- c(10, 5, 0.5); Omega <- c(0.9, 0.01, 0.01)
phi <- sapply(1:3, function(i) rnorm(21, mu[i], sqrt(Omega[i])))
model <- set.to.class("mixedDiffusion",
               parameter = list(phi = phi, mu = mu, Omega = Omega, gamma2 = 0.1),
               y0.fun = y0.fun, b.fun = b.fun, sT.fun = function(t, x) 1)
t <- seq(0, 1, by = 0.01)
data <- simulate(model, t = t, plot.series = TRUE)
est <- estimate(model, t, data[1:20,], 100)  # nMCMC should be much larger
plot(est)

##
t.list <- list()
for(i in 1:20) t.list[[i]] <- t
t.list[[21]] <- t[1:50]
data.list <- list()
for(i in 1:20) data.list[[i]] <- data[i,]
data.list[[21]] <- data[21, 1:50]
est <- estimate(model, t.list, data.list, 100)
pred <- predict(est, t = t[50:101], which.series = "current", ind.pred = 21,
   b.fun.mat = function(phi, t, y) phi[,1]-phi[,2]*y)
}
\references{
Hermann, S., K. Ickstadt and C. H. Mueller (2016).
Bayesian Prediction of Crack Growth Based on a Hierarchical Diffusion Model.
Applied Stochastic Models in Business and Industry, DOI: 10.1002/asmb.2175.
}

