% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbg-cnbd-k.R
\name{mbgcnbd.PlotRecVsConditionalExpectedFrequency}
\alias{mbgcnbd.PlotRecVsConditionalExpectedFrequency}
\alias{bgcnbd.PlotRecVsConditionalExpectedFrequency}
\title{(M)BG/CNBD-k Plot Actual vs. Conditional Expected Frequency by Recency}
\usage{
mbgcnbd.PlotRecVsConditionalExpectedFrequency(
  params,
  cal.cbs,
  T.star,
  x.star,
  xlab = "Calibration period recency",
  ylab = "Holdout period transactions",
  xticklab = NULL,
  title = "Actual vs. Conditional Expected Transactions by Recency"
)

bgcnbd.PlotRecVsConditionalExpectedFrequency(
  params,
  cal.cbs,
  T.star,
  x.star,
  xlab = "Calibration period recency",
  ylab = "Holdout period transactions",
  xticklab = NULL,
  title = "Actual vs. Conditional Expected Transactions by Recency"
)
}
\arguments{
\item{params}{A vector with model parameters \code{k}, \code{r},
\code{alpha}, \code{a} and \code{b}, in that order.}

\item{cal.cbs}{Calibration period CBS (customer by sufficient statistic). It
must contain columns for frequency ('x'), recency ('t.x') and total time
observed ('T.cal').}

\item{T.star}{Length of the holdout period.}

\item{x.star}{Vector of transactions made by each customer in the holdout period.}

\item{xlab}{Descriptive label for the x axis.}

\item{ylab}{Descriptive label for the x axis.}

\item{xticklab}{A vector containing a label for each tick mark on the x axis.}

\item{title}{Title placed on the top-center of the plot.}
}
\value{
Matrix comparing actual and conditional expected transactions in the holdout period.
}
\description{
Plots the actual and conditional expected number transactions made by
customers in the holdout period, binned according to calibration period
recencies, and returns this comparison in a matrix.
}
\examples{
\dontrun{
data("groceryElog")
cbs <- elog2cbs(groceryElog, T.cal = "2006-09-30")
params <- mbgcnbd.EstimateParameters(cbs, k=2)
mbgcnbd.PlotRecVsConditionalExpectedFrequency(params, cbs, T.star=52, cbs$x.star)
}
}
\seealso{
\code{\link{bgcnbd.PlotFreqVsConditionalExpectedFrequency}}
}
