% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BT_Summary.R
\name{summary.BTFit}
\alias{summary.BTFit}
\title{Summary of a BTFit object.}
\usage{
\method{summary}{BTFit}(
  object,
  cBars = length(object$var.names),
  n.iter = object$BTParams$n.iter,
  plot_it = TRUE,
  order_it = TRUE,
  method = .BT_relative_influence,
  normalize = TRUE,
  ...
)
}
\arguments{
\item{object}{a \code{\link{BTFit}} object.}

\item{cBars}{the number of bars to plot. If \code{order=TRUE} only the variables with the \code{cBars} largest relative influence will appear in the barplot.
If \code{order=FALSE} then the first \code{cBars} variables will appear in the barplot.}

\item{n.iter}{the number of trees used to compute the relative influence. Only the first \code{n.iter} trees will be used.}

\item{plot_it}{an indicator as to whether the plot is generated.}

\item{order_it}{an indicator as to whether the plotted and/or returned relative influences are sorted.}

\item{method}{the function used to compute the relative influence. Currently, only \code{\link{.BT_relative_influence}} is available (default value as well).}

\item{normalize}{if \code{TRUE} returns the normalized relative influence.}

\item{...}{additional argument passed to the plot function.}
}
\value{
Returns a data frame where the first component is the variable name and the second one is the computed relative influence, normalized to sum up to 100.
Depending on the \code{plot_it} value, the relative influence plot will be performed.
}
\description{
Computes the relative influence of each variable in the BTFit object.
}
\details{
Please note that the relative influence for variables having an original \strong{negative} relative influence is forced to 0.
}
\references{
M. Denuit, D. Hainaut and J. Trufin (2019). \strong{Effective Statistical Learning Methods for Actuaries |: GLMs and Extensions}, \emph{Springer Actuarial}.

M. Denuit, D. Hainaut and J. Trufin (2019). \strong{Effective Statistical Learning Methods for Actuaries ||: Tree-Based Methods and Extensions}, \emph{Springer Actuarial}.

M. Denuit, D. Hainaut and J. Trufin (2019). \strong{Effective Statistical Learning Methods for Actuaries |||: Neural Networks and Extensions}, \emph{Springer Actuarial}.

M. Denuit, D. Hainaut and J. Trufin (2022). \strong{Response versus gradient boosting trees, GLMs and neural networks under Tweedie loss and log-link}.
Accepted for publication in \emph{Scandinavian Actuarial Journal}.

M. Denuit, J. Huyghe and J. Trufin (2022). \strong{Boosting cost-complexity pruned trees on Tweedie responses: The ABT machine for insurance ratemaking}.
Paper submitted for publication.

M. Denuit, J. Trufin and T. Verdebout (2022). \strong{Boosting on the responses with Tweedie loss functions}. Paper submitted for publication.
}
\seealso{
\code{\link{BT}}, \code{\link{.BT_relative_influence}}.
}
\author{
Gireg Willame \email{gireg.willame@gmail.com}

\emph{This package is inspired by the \code{gbm3} package. For more details, see \url{https://github.com/gbm-developers/gbm3/}}.
}
