% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multMixNRMI.R
\name{as.mcmc.multNRMI}
\alias{as.mcmc.multNRMI}
\title{Convert the output of multMixNRMI into a coda mcmc object}
\usage{
\method{as.mcmc}{multNRMI}(x, ..., thinning_to = 1000, ncores = parallel::detectCores())
}
\arguments{
\item{x}{Output of multMixNRMI.}

\item{...}{Further arguments to be passed to specific methods}

\item{thinning_to}{Final length of the chain after thinning.}

\item{ncores}{Specify the number of cores to use in the conversion}
}
\value{
a coda::mcmc object
}
\description{
Convert the output of multMixNRMI into a coda mcmc object
}
\examples{
data(acidity)
out <- multMixNRMI1(acidity, parallel = TRUE, Nit = 10, ncores = 2)
coda::as.mcmc(out, ncores = 2)
}
