% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_prior.R
\name{get_prior}
\alias{get_prior}
\title{Construct Prior Parameters for the BKP Model}
\usage{
get_prior(
  prior = c("noninformative", "fixed", "adaptive"),
  r0 = 2,
  p0 = 0.5,
  y = NULL,
  m = NULL,
  K = NULL
)
}
\arguments{
\item{prior}{Character string specifying the type of prior to use. One of
\code{"noninformative"}, \code{"fixed"}, or \code{"adaptive"}.}

\item{r0}{Positive scalar indicating the global precision parameter. Used
when \code{prior} is \code{"fixed"} or \code{"adaptive"}.}

\item{p0}{Prior mean for the success probability (in (0,1)). Used only when
\code{prior = "fixed"}.}

\item{y}{Numeric vector of observed successes, of length \code{n}.}

\item{m}{Numeric vector of total binomial trials, of length \code{n}.}

\item{K}{A precomputed kernel matrix of size \code{n × n}, typically obtained
from \code{\link{kernel_matrix}}.}
}
\value{
A list with two numeric vectors:
\describe{
\item{\code{alpha0}}{Prior alpha parameters of the Beta distribution, length \code{n}.}
\item{\code{beta0}}{Prior beta parameters of the Beta distribution, length \code{n}.}
}
}
\description{
Computes the prior Beta distribution parameters \code{alpha0}
and \code{beta0} at each input location, based on the chosen prior
specification. Supports noninformative, fixed, and data-adaptive prior
strategies.
}
\details{
\itemize{
\item For \code{prior = "noninformative"}, all prior parameters are set to 1 (noninformative prior).
\item For \code{prior = "fixed"}, all locations share the same Beta prior:
\code{Beta(r0 * p0, r0 * (1 - p0))}.
\item For \code{prior = "adaptive"}, the prior mean at each location is computed by
kernel smoothing the observed proportions \code{y/m}, and precision \code{r0}
is distributed accordingly.
}
}
\examples{
# Simulated data
set.seed(123)
n <- 10
X <- matrix(runif(n * 2), ncol = 2)
y <- rbinom(n, size = 5, prob = 0.6)
m <- rep(5, n)

# Example kernel matrix (Gaussian)
K <- kernel_matrix(X)

# Construct adaptive prior
prior <- get_prior(prior = "adaptive", r0 = 2, y = y, m = m, K = K)

}
\references{
Zhao J, Qing K, Xu J (2025). \emph{BKP: An R Package for Beta
Kernel Process Modeling}.  arXiv.
https://doi.org/10.48550/arXiv.2508.10447.
}
\seealso{
\code{\link{get_prior_dkp}}, \code{\link{fit.BKP}},
\code{\link{predict.BKP}}, \code{\link{kernel_matrix}}
}
