% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FINAL_FUNCTIONS_chi2_test.R
\name{chi2_test_BFF}
\alias{chi2_test_BFF}
\title{chi2_test_BFF}
\usage{
chi2_test_BFF(
  chi2_stat,
  n,
  LRT = FALSE,
  omega = NULL,
  omega_sequence = if (is.null(omega)) seq(0.01, 1, by = 0.01),
  r = 1
)
}
\arguments{
\item{chi2_stat}{chi-square statistic}

\item{n}{sample size (if one sample test)}

\item{LRT}{should LRT be performed? Default is FALSE}

\item{omega}{standardized effect size. For the chi^2-test, this is often called Cohen's w (can be a single entry or a vector of values)}

\item{omega_sequence}{sequence of standardized effect sizes. If no omega is provided, omega_sequence is set to be seq(0.01, 1, by = 0.01)}

\item{r}{variable controlling dispersion of non-local priors. Default is 1.}
}
\value{
Returns an S3 object of class `BFF` (see `BFF.object` for details).
}
\description{
chi2_test_BFF constructs BFFs based on the t test. BFFs depend on hyperparameters r and tau^2 which determine the shape and scale of the prior distributions which define the alternative hypotheses.
By setting r > 1, we use higher-order moments for replicated studies. Fractional moments are set with r > 1 and r not an integer.
All results are on the log scale.
}
\examples{
chi2BFF = chi2_test_BFF(chi2_stat = 6.5, n = 10)
chi2BFF
plot(chi2BFF)

}
