% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ceaf.plot.R
\name{ceaf.plot.pairwise}
\alias{ceaf.plot.pairwise}
\alias{ceaf.plot}
\title{Cost-Effectiveness Acceptability Frontier (CEAF) plot}
\usage{
\method{ceaf.plot}{pairwise}(mce, graph = c("base", "ggplot2", "plotly"), ...)

ceaf.plot(mce, ...)
}
\arguments{
\item{mce}{The output of the call to the function \code{\link[=multi.ce]{multi.ce()}}}

\item{graph}{A string used to select the graphical engine to use for
plotting. Should (partial-) match the two options \code{"base"} or
\code{"ggplot2"}. Default value is \code{"base"}.}

\item{...}{Additional arguments}
}
\value{
\item{ceaf}{A ggplot object containing the plot. Returned only if
\code{graph="ggplot2"}.}
}
\description{
Produces a plot the Cost-Effectiveness Acceptability Frontier (CEAF)
against the willingness to pay threshold.
}
\examples{

# See Baio G., Dawid A.P. (2011) for a detailed description of the 
# Bayesian model and economic problem

# Load the processed results of the MCMC simulation model
data(Vaccine)

# Runs the health economic evaluation using BCEA
m <- bcea(
      e=eff,
      c=cost,               # defines the variables of 
                            #  effectiveness and cost
      ref=2,                # selects the 2nd row of (e, c) 
                            #  as containing the reference intervention
      interventions=treats, # defines the labels to be associated 
                            #  with each intervention
      Kmax=50000,           # maximum value possible for the willingness 
                            #  to pay threshold; implies that k is chosen 
                            #  in a grid from the interval (0, Kmax)
      plot=FALSE            # inhibits graphical output
)

\donttest{
mce <- multi.ce(m)          # uses the results of the economic analysis 
}

\donttest{
ceaf.plot(mce)              # plots the CEAF 
}

\donttest{
ceaf.plot(mce, graph = "g") # uses ggplot2 
}

\donttest{
# Use the smoking cessation dataset
data(Smoking)
m <- bcea(eff, cost, ref = 4, intervention = treats, Kmax = 500, plot = FALSE)
mce <- multi.ce(m)
ceaf.plot(mce)
}
 
}
\references{
\insertRef{Baio2011}{BCEA}

\insertRef{Baio2013}{BCEA}
}
\seealso{
\code{\link[=bcea]{bcea()}},
\code{\link[=multi.ce]{multi.ce()}}
}
\author{
Gianluca Baio, Andrea Berardi
}
\keyword{hplot}
