% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{mixture}
\alias{mixture}
\title{Mixture model.}
\usage{
mixture(
  comm,
  tree,
  q = 0,
  precision = 0.1,
  replace = TRUE,
  alpha = 0.05,
  param = TRUE,
  runs = 1000
)
}
\arguments{
\item{comm}{A sites x species matrix, with abundance data.}

\item{tree}{A phylo or hclust object (used only for PD or FD) or alternatively a species x traits matrix or data.frame to build a functional tree. Will only be used if q = 0, in which case phylogenetic or functional richness are calculated instead of species richness.}

\item{q}{Hill number order: q(0) = species richness, q(1) ~ Shannon diversity, q(2) ~ Simpson diversity.}

\item{precision}{Precision of the proportion of each habitat type to be tested.}

\item{replace}{Boolean indicating whether simulations should be with or without (default) replacement.}

\item{alpha}{alpha value for significance level.}

\item{param}{Value is calculated with parametric or non-parametric method. The later is preferable when distribution of estimated values is not normally distributed.}

\item{runs}{Number of runs for the bootstrap providing confidence limits.}
}
\value{
A matrix with expected diversity at each proportion of different habitats in a landscape.
}
\description{
Mixture model by Hilario et al. (2025)
}
\details{
A tool to assess biodiversity in landscapes containing varying proportions of n environments.
}
\examples{
comm <- matrix(c(20,20,20,20,20,9,1,0,0,0,1,1,1,1,1), nrow = 3, ncol = 5, byrow = TRUE)
tree = tree.build(dist(1:5))

hill(comm)
alpha(comm, tree)

mixture(comm, runs = 10)
mixture(comm, tree, replace = TRUE, runs = 10)
}
\references{
Chao et al. (2019) Proportional mixture of two rarefaction/extrapolation curves to forecast biodiversity changes under landscape transformation. Ecology Letters, 22: 1913-1922. https://doi.org/10.1111/ele.13322

Hilario et al. (2025) Hilário, R. et al. (2025) A new tool to quantify biodiversity change under landscape transformation. Ecological Applications, 35: e3017.
}
\author{
Renato Hilario & Pedro Cardoso
}
