% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl.R
\name{export}
\alias{export}
\alias{export.kusto_database_endpoint}
\alias{export.tbl_kusto}
\title{Execute the Kusto query and export the result to Azure Storage.}
\usage{
export(
  tbl,
  storage_uri,
  query = NULL,
  name_prefix = "export",
  key = "impersonate",
  format = "parquet",
  distributed = FALSE,
  ...
)

\method{export}{kusto_database_endpoint}(
  tbl,
  storage_uri,
  query = NULL,
  name_prefix = "export",
  key = "impersonate",
  format = "parquet",
  distributed = FALSE,
  ...
)

\method{export}{tbl_kusto}(
  tbl,
  storage_uri,
  query = NULL,
  name_prefix = "export",
  key = "impersonate",
  format = "parquet",
  distributed = FALSE,
  ...
)
}
\arguments{
\item{tbl}{A Kusto database endpoint object, as returned by \code{kusto_database_endpoint}.}

\item{storage_uri}{The Azure Storage URI to export files to.}

\item{query}{A Kusto query string}

\item{name_prefix}{The filename prefix to use for exported files.}

\item{key}{default "impersonate" which uses the account signed into Kusto to
authenticate to Azure Storage. An Azure Storage account key.}

\item{format}{Options are "parquet", "csv", "tsv", "json"}

\item{distributed}{logical, indicates whether Kusto should distributed the
export job to multiple nodes, in which case multiple files will be written
to storage concurrently.}

\item{...}{needed for agreement with generic. Not otherwise used.}
}
\description{
Execute the Kusto query and export the result to Azure Storage.

Execute the Kusto query and export the result to Azure Storage.
}
