% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run-pgs-statistics.R
\name{run.pgs.regression}
\alias{run.pgs.regression}
\title{Run linear and logistic regression on a polygenic score and a set of phenotypes}
\usage{
run.pgs.regression(pgs, phenotype.data)
}
\arguments{
\item{pgs}{numeric vector of polygenic scores}

\item{phenotype.data}{data.frame of phenotypes}
}
\value{
data frame with columns for phenotype, model, beta, se, p.value, r.squared, and AUC
}
\description{
Phenotype data variables are automatically classified as continuous or binary and a simple linear regression or logistic regression, respectively, is run between the polygenic score and each phenotype.
Categorical phenotypes with more than two category are ignored.
If a binary variable is not formatted as a factor, it is converted to a factor using \code{as.factor()} defaults. For logistic regression, the first level is classified as "failure" and the second "success" by \code{glm()} defaults.
}
\examples{
set.seed(200);
pgs <- rnorm(200, 0, 1);
phenotype.data <- data.frame(
    continuous.pheno = rnorm(200, 1, 1),
    binary.pheno = sample(c(0, 1), 200, replace = TRUE)
    );
run.pgs.regression(pgs, phenotype.data);
}
