% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SH_function.R
\name{SH}
\alias{SH}
\title{Analysis: Steinhart-Hart}
\usage{
SH(
  trat,
  resp,
  initial = NA,
  sample.curve = 1000,
  ylab = "Dependent",
  xlab = "Independent",
  theme = theme_classic(),
  legend.position = "top",
  r2 = "all",
  error = "SE",
  point = "all",
  width.bar = NA,
  scale = "none",
  textsize = 12,
  pointsize = 4.5,
  linesize = 0.8,
  linetype = 1,
  pointshape = 21,
  fillshape = "gray",
  colorline = "black",
  round = NA,
  yname.formula = "y",
  xname.formula = "x",
  comment = NA,
  fontfamily = "sans"
)
}
\arguments{
\item{trat}{Numeric vector with dependent variable.}

\item{resp}{Numeric vector with independent variable.}

\item{initial}{Starting estimates}

\item{sample.curve}{Provide the number of observations to simulate curvature (default is 1000)}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{Treatments name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_bw())}

\item{legend.position}{Legend position (\emph{default} is "top")}

\item{r2}{Coefficient of determination of the mean or all values (\emph{default} is all)}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{point}{Defines whether you want to plot all points ("all") or only the mean ("mean")}

\item{width.bar}{Bar width}

\item{scale}{Sets x scale (\emph{default} is none, can be "log")}

\item{textsize}{Font size}

\item{pointsize}{Shape size}

\item{linesize}{Line size}

\item{linetype}{line type}

\item{pointshape}{Format point (default is 21)}

\item{fillshape}{Fill shape}

\item{colorline}{Color lines}

\item{round}{round equation}

\item{yname.formula}{Name of y in the equation}

\item{xname.formula}{Name of x in the equation}

\item{comment}{Add text after equation}

\item{fontfamily}{Font family}
}
\value{
The function returns a list containing the coefficients and their respective values of p; statistical parameters such as AIC, BIC, pseudo-R2, RMSE (root mean square error); largest and smallest estimated value and the graph using ggplot2 with the equation automatically.
}
\description{
The Steinhart-Hart model. The Steinhart-Hart equation is a model used to explain the behavior of a semiconductor at different temperatures, however, Zhai et al. (2020) used this model to relate plant density and grain yield.
}
\details{
The model function for the Steinhart-Hart model is:
\deqn{ y = \frac{1}{A+B \times ln(x)+C \times ln(x)^3}}
}
\examples{
library(AgroReg)
data("aristolochia")
attach(aristolochia)
SH(trat,resp)
}
\references{
Zhai, L., Li, H., Song, S., Zhai, L., Ming, B., Li, S., ... & Zhang, L. (2021). Intra-specific competition affects the density tolerance and grain yield of maize hybrids. Agronomy Journal, 113(1), 224-23. doi:10.1002/agj2.20438
}
\seealso{
\link{LL}, \link{CD},\link{GP}
}
\author{
Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
