% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot2dgrid.R
\name{group_2d_grid}
\alias{group_2d_grid}
\title{Plot of labels indicating adjacent groups using the grid package}
\usage{
group_2d_grid(
  zargs,
  glabs = NULL,
  sep = "\\n",
  loc = c(0.5, 0.5),
  draw = FALSE,
  ...
)
}
\arguments{
\item{zargs}{argument list as passed from \code{\link{zenplot}()}}

\item{glabs}{group labels being indexed by the plot variables
(and thus of length as the number of variables);
if NULL then they are determined with extract_2d()}

\item{sep}{group label separator}

\item{loc}{(x,y)-location in [0,1]^2; 0 corresponds to left, 1 to right (in
the direction of the path)}

\item{draw}{logical indicating whether drawing should take place}

\item{...}{additional arguments passed to gpar()}
}
\value{
grob (invisibly)
}
\description{
Plot of labels indicating adjacent groups using the grid package
}
\note{
For performance reasons (avoiding having to call extract_2d() twice),
      'glabs' is an extra argument
}
\seealso{
Other default 2d plot functions using the grid package: 
\code{\link{arrow_2d_grid}()},
\code{\link{axes_2d_grid}()},
\code{\link{density_2d_grid}()},
\code{\link{label_2d_grid}()},
\code{\link{points_2d_grid}()},
\code{\link{qq_2d_grid}()},
\code{\link{rect_2d_grid}()}

Other default 2d plot functions: 
\code{\link{arrow_2d_graphics}()},
\code{\link{arrow_2d_grid}()},
\code{\link{arrow_2d_loon}()},
\code{\link{axes_2d_graphics}()},
\code{\link{axes_2d_grid}()},
\code{\link{axes_2d_loon}()},
\code{\link{density_2d_graphics}()},
\code{\link{density_2d_grid}()},
\code{\link{density_2d_loon}()},
\code{\link{extract_2d}()},
\code{\link{group_2d_graphics}()},
\code{\link{group_2d_loon}()},
\code{\link{label_2d_graphics}()},
\code{\link{label_2d_grid}()},
\code{\link{label_2d_loon}()},
\code{\link{points_2d_graphics}()},
\code{\link{points_2d_grid}()},
\code{\link{points_2d_loon}()},
\code{\link{qq_2d_graphics}()},
\code{\link{qq_2d_grid}()},
\code{\link{rect_2d_graphics}()},
\code{\link{rect_2d_grid}()},
\code{\link{rect_2d_loon}()}
}
\author{
Marius Hofert
}
\concept{default 2d plot functions}
\concept{default 2d plot functions using the grid package}
