% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot1dloon.R
\name{label_1d_loon}
\alias{label_1d_loon}
\title{Label plot in 1d using the interactive loon package}
\usage{
label_1d_loon(
  zargs,
  loc.x = NULL,
  loc.y = NULL,
  label = NULL,
  rot = NULL,
  size = 8,
  box = FALSE,
  color = NULL,
  linkingGroup = NULL,
  showLabels = FALSE,
  showScales = FALSE,
  showGuides = FALSE,
  baseplot = NULL,
  parent = NULL,
  ...
)
}
\arguments{
\item{zargs}{The argument list as passed from \code{\link{zenplot}()}}

\item{loc.x}{x-location of the label}

\item{loc.y}{y-location of the label}

\item{label}{The label to be used}

\item{rot}{The rotation of the label}

\item{size}{The font size}

\item{box}{A \code{\link{logical}} indicating whether the label is to be enclosed
in a box.}

\item{color}{Color of the label (and of box when \code{box = TRUE}).}

\item{linkingGroup}{A string specifying the initial group of plots to be
linked to this plot}

\item{showLabels}{Logical determining whether axis labels are displayed}

\item{showScales}{Logical determining whether scales are displayed}

\item{showGuides}{Logical determining whether the background guidelines
are displayed}

\item{baseplot}{If non-null the base plot on which the plot should be
layered}

\item{parent}{The tk parent for this loon plot widget}

\item{...}{Additional parameters passed to loon::l_layer_text(...)}
}
\value{
A loon::l_plot(...)
}
\description{
Label plot in 1d using the interactive loon package
}
\seealso{
Other default 1d plot functions using the interactive loon package: 
\code{\link{arrow_1d_loon}()},
\code{\link{boxplot_1d_loon}()},
\code{\link{density_1d_loon}()},
\code{\link{hist_1d_loon}()},
\code{\link{jitter_1d_loon}()},
\code{\link{lines_1d_loon}()},
\code{\link{points_1d_loon}()},
\code{\link{rect_1d_loon}()},
\code{\link{rug_1d_loon}()}

Other default 1d plot functions: 
\code{\link{arrow_1d_graphics}()},
\code{\link{arrow_1d_grid}()},
\code{\link{arrow_1d_loon}()},
\code{\link{boxplot_1d_graphics}()},
\code{\link{boxplot_1d_grid}()},
\code{\link{boxplot_1d_loon}()},
\code{\link{density_1d_graphics}()},
\code{\link{density_1d_grid}()},
\code{\link{density_1d_loon}()},
\code{\link{extract_1d}()},
\code{\link{hist_1d_graphics}()},
\code{\link{hist_1d_grid}()},
\code{\link{hist_1d_loon}()},
\code{\link{jitter_1d_graphics}()},
\code{\link{jitter_1d_grid}()},
\code{\link{jitter_1d_loon}()},
\code{\link{label_1d_graphics}()},
\code{\link{label_1d_grid}()},
\code{\link{lines_1d_graphics}()},
\code{\link{lines_1d_grid}()},
\code{\link{lines_1d_loon}()},
\code{\link{points_1d_graphics}()},
\code{\link{points_1d_grid}()},
\code{\link{points_1d_loon}()},
\code{\link{rect_1d_graphics}()},
\code{\link{rect_1d_grid}()},
\code{\link{rect_1d_loon}()},
\code{\link{rug_1d_graphics}()},
\code{\link{rug_1d_grid}()},
\code{\link{rug_1d_loon}()}
}
\author{
Marius Hofert and Wayne Oldford
}
\concept{default 1d plot functions}
\concept{default 1d plot functions using the interactive loon package}
