% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explicit_guide_factor.R
\name{explicit_guide.factor}
\alias{explicit_guide.factor}
\title{Coerce Factor Guide to Something More Explicit}
\usage{
\method{explicit_guide}{factor}(
  x,
  ...,
  overwrite = getOption("yamlet_explicit_guide_overwrite", TRUE),
  simplify = getOption("yamlet_explicit_guide_simplify", TRUE),
  expand = getOption("yamlet_expand_codelist", TRUE)
)
}
\arguments{
\item{x}{factor}

\item{...}{named arguments passed to \code{\link{as_yamlet}}, \code{\link{explicit_guide}}, and \code{\link{decorate}}; un-named arguments ignored}

\item{overwrite}{whether to overwrite attributes}

\item{simplify}{whether to remove guide attribute}

\item{expand}{whether to expand empty guide list using sorted unique values. NA likely excluded.}
}
\value{
factor
}
\description{
Coerces factor 'guide' attribute to something more explicit.
The attribute 'guide' generally suggests a guide
to interpretation of a data item, such as units, formats, codelists,
and encodings.  The idea here is to replace 'guide' with something
explicit in case required downstream. Generally a codelist is expected, but not enforced.
}
\examples{
library(magrittr)
x <- data.frame(
 ID = as_dvec(1),
 SEX = factor(1)
)
x \%<>\% modify(SEX, label = 'sex', guide = list(female = 0, male = 1))
x \%>\% decorations
x \%>\% explicit_guide \%>\% decorations
x \%>\% explicit_guide(SEX) \%>\% decorations # limit scope
x \%$\% SEX \%>\% explicit_guide
}
\seealso{
Other explicit_guide: 
\code{\link{explicit_guide}()},
\code{\link{explicit_guide.data.frame}()},
\code{\link{explicit_guide.dvec}()},
\code{\link{explicit_guide.yamlet}()},
\code{\link{implicit_guide}()},
\code{\link{implicit_guide.data.frame}()},
\code{\link{implicit_guide.dvec}()},
\code{\link{implicit_guide.factor}()},
\code{\link{infer_guide}()}
}
\concept{explicit_guide}
\keyword{internal}
