% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaling.R
\name{ScalingFitness}
\alias{ScalingFitness}
\title{Abstract interface for ScaleFitness.}
\usage{
ScalingFitness(fit, lF)
}
\arguments{
\item{fit}{A fitness vector.}

\item{lF}{Local configuration.}
}
\value{
Scaled fitness vector
}
\description{
The scaling constant \code{k} is  
             set by the function \code{lF$ScalingExp}.
}
\examples{
lF<-list()
lF$Offset<-parm(0.0001)
lF$ScalingExp<-parm(2)
fit<-sample(10, 20, replace=TRUE)
fit
ScalingFitness(fit, lF)
}
\seealso{
Other Scaling: 
\code{\link{ContinuousScaleFitness}()},
\code{\link{DispersionRatio}()},
\code{\link{ScaleFitness}()},
\code{\link{ThresholdScaleFitness}()}
}
\concept{Scaling}
