% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wikiTools.R
\name{getWikiFiles}
\alias{getWikiFiles}
\title{Downloads a list of Wikipedia pages in a specified path of the computer, and return a vector of the no-found names (if any).}
\usage{
getWikiFiles(X, language = c("es", "en", "fr"), directory = "./", maxtime = 0)
}
\arguments{
\item{X}{A vector of Wikipedia's entry).}

\item{language}{The language of the Wikipedia page version. This should consist of an ISO language code (default = "en").}

\item{directory}{Directory where to export the files to.}

\item{maxtime}{In case you want to apply a random waiting between consecutive searches.}
}
\value{
It returns a vector of errors, if any. All pictures are download into the selected directory (NULL= no errors).
}
\description{
Downloads a list of Wikipedia pages in a specified path of the computer, and return a vector of the no-found names (if any).
}
\details{
This function allows download a set of Wikipedia pages into a directory of the local computer.
All the errors (not found pages) are reported as outcomes (NULL= no errors). The files are donwload into your chosen directory.
}
\examples{
## Not run: 

## In case you want to download the Wikipage of a person:

# getWikiFiles("Rembrandt", dir = "./")

## Or the pics of multiple authors: 

# B <- c("Monet", "Renoir", "Caillebotte")
# getWikiFiles(B, dir = "./", language="fr")

## End(Not run)
}
\author{
Modesto Escobar, Department of Sociology and Communication, University of Salamanca. See \url{https://sociocav.usal.es/blog/modesto-escobar/}
}
