% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machine_learning.R
\name{wbt_dbscan}
\alias{wbt_dbscan}
\title{Dbscan}
\usage{
wbt_dbscan(
  inputs,
  output,
  scaling = "Normalize",
  search_dist = 0.01,
  min_points = 5,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{inputs}{Names of the input rasters.}

\item{output}{Name of the output raster file.}

\item{scaling}{Scaling method for predictors. Options include 'None', 'Normalize', and 'Standardize'.}

\item{search_dist}{Search-distance parameter.}

\item{min_points}{Minimum point density needed to define 'core' point in cluster.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Performs a DBSCAN-based unsupervised clustering operation.
}
\keyword{MachineLearning}
