% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmplotting_helpers.R
\name{plot_km_curves_counting}
\alias{plot_km_curves_counting}
\title{Plot KM curves for two groups with optional confidence intervals and censoring marks}
\usage{
plot_km_curves_counting(
  at_points,
  S0.KM,
  idx0,
  idv0,
  S1.KM,
  idx1,
  idv1,
  col.0,
  col.1,
  ltys,
  lwds,
  Xlab,
  Ylab,
  ylim,
  xlim,
  show.ticks = FALSE,
  cens0 = NULL,
  risk.points,
  risk.points.label,
  cens1 = NULL,
  se0.KM = NULL,
  se1.KM = NULL,
  conf.int = FALSE,
  conf_level = 0.95,
  censor.cex = 1,
  time.zero = 0,
  tpoints.add = c(0),
  ...
)
}
\arguments{
\item{at_points}{Numeric vector of time points for plotting.}

\item{S0.KM}{Numeric vector of survival probabilities for group 0.}

\item{idx0}{Indices for censoring in group 0.}

\item{idv0}{Indices for events in group 0.}

\item{S1.KM}{Numeric vector of survival probabilities for group 1.}

\item{idx1}{Indices for censoring in group 1.}

\item{idv1}{Indices for events in group 1.}

\item{col.0}{Color for group 0.}

\item{col.1}{Color for group 1.}

\item{ltys}{Line types for groups.}

\item{lwds}{Line widths for groups.}

\item{Xlab}{X-axis label.}

\item{Ylab}{Y-axis label.}

\item{ylim}{Y-axis limits.}

\item{xlim}{X-axis limits.}

\item{show.ticks}{Logical; show censoring marks (default FALSE).}

\item{cens0}{Numeric vector of censoring times for group 0.}

\item{risk.points}{Numeric vector of risk time points.}

\item{risk.points.label}{Character vector of labels for risk time points.}

\item{cens1}{Numeric vector of censoring times for group 1.}

\item{se0.KM}{Numeric vector of standard errors for group 0.}

\item{se1.KM}{Numeric vector of standard errors for group 1.}

\item{conf.int}{Logical; show confidence intervals (default FALSE).}

\item{conf_level}{Confidence level (default 0.95).}

\item{censor.cex}{Numeric; censoring mark size (default 1.0).}

\item{time.zero}{Numeric; time zero value for risk table alignment (default 0).}

\item{tpoints.add}{Numeric vector; additional time points to include (default c(0)).}

\item{...}{Additional arguments to plot.}
}
\value{
Invisibly returns NULL. Used for plotting side effects.
}
\description{
Plots Kaplan-Meier survival curves for two groups, with options for confidence intervals and censoring marks.
}
