% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{model_metrics_tab}
\alias{model_metrics_tab}
\alias{model_tab}
\title{Output a regression table with estimates and macro statistics
for multiple categorical or metric independent variables}
\usage{
model_metrics_tab(
  data,
  col,
  categorical,
  metric,
  interactions = NULL,
  adjust = "fdr",
  labels = TRUE,
  clean = TRUE,
  ...
)
}
\arguments{
\item{data}{A tibble.}

\item{col}{The target column holding metric values.}

\item{categorical}{A tidy column selection holding independet categorical variables.}

\item{metric}{A tidy column selection holding independent metric variables.}

\item{interactions}{A vector of interaction effects to calculate.
Each interaction effect should be provided as multiplication of the variables.
Example: \code{c(sd_gender * adopter)}.}

\item{adjust}{Performing multiple significance tests inflates the alpha error.
Thus, p values need to be adjusted according to the number of tests.
Set a method supported by  \code{stats::\link[stats:p.adjust]{p.adjust}},
e.g. "fdr" (the default) or "bonferroni". Disable adjustment with FALSE.}

\item{labels}{If TRUE (default) extracts labels from the attributes, see \link{codebook}.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{effect_metrics}.}
}
\value{
A volker list object containing volker tables with the requested statistics.
}
\description{
The regression output comes from \code{stats::\link[stats:lm]{lm}}.
The effect sizes are calculated by \code{heplots::\link[heplots:etasq]{etasq}}.
The variance inflation is calculated by \code{car::\link[car:vif]{vif}}.
The standardized beta (in the column standard beta) is calculated by
multiplying the estimate with the ratio \code{x_sd / y_sd} where x_sd contains
the standard deviation of the predictor values and y_sd the standard deviation of
the predicted value.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
library(volker)
data <- volker::chatgpt

data |>
  filter(sd_gender != "diverse") |>
  model_metrics_tab(use_work, categorical = c(sd_gender, adopter), metric = sd_age)

}
\keyword{internal}
