% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log-dir.R
\name{vitals_log_dir}
\alias{vitals_log_dir}
\alias{vitals_log_dir_set}
\title{The log directory}
\usage{
vitals_log_dir()

vitals_log_dir_set(dir)
}
\arguments{
\item{dir}{A directory to configure the environment variable
\code{VITALS_LOG_DIR} to.}
}
\value{
Both \code{vitals_log_dir()} and \code{vitals_log_dir_set()} return the current
value of the environment variable \code{VITALS_LOG_DIR}. \code{vitals_log_dir_set()}
additionally sets it to a new value.

To set this variable in every new R session, you might consider adding it
to your \code{.Rprofile}, perhaps with \code{usethis::edit_r_profile()}.
}
\description{
vitals supports the \code{VITALS_LOG_DIR} environment variable,
which sets a default directory to write logs to in \link{Task}'s \verb{$eval()}
and \verb{$log()} methods.
}
\examples{
vitals_log_dir()

dir <- tempdir()

vitals_log_dir_set(dir)

vitals_log_dir()
}
