% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask_names.R
\name{mask_names}
\alias{mask_names}
\title{Mask variable names with anonymous labels}
\usage{
mask_names(data, ..., prefix)
}
\arguments{
\item{data}{A data frame.}

\item{...}{Columns to mask using tidyselect semantics. All arguments are combined into
a single set. Each can be:
\itemize{
\item Bare column names (e.g., \code{var1, var2})
\item A tidyselect expression (e.g., \code{starts_with("treatment_")})
\item A character vector of column names (e.g., \code{c("var1", "var2")})
}}

\item{prefix}{character string to use as prefix for masked names.
This becomes the base prefix, with numeric suffixes appended (e.g.,
\code{prefix = "treatment_"} produces "treatment_01", "treatment_02", etc.).
The prefix is used as-is, so include a separator (e.g., underscore) if desired.}
}
\value{
A data frame with the specified variables renamed to masked names.
}
\description{
Assigns new masked names to selected variables in a data frame.
All selected variables are combined into a single set and renamed with
a common prefix. To mask different variable groups with different prefixes,
call the function separately for each group.
}
\examples{
df <- data.frame(
  treat_1 = c(1, 2, 3),
  treat_2 = c(4, 5, 6),
  outcome_a = c(7, 8, 9),
  outcome_b = c(10, 11, 12),
  id = 1:3
)

# Mask one set of variables
library(dplyr)
mask_names(df, starts_with("treat_"), prefix = "A_")

# Using character vectors
mask_names(df, c("treat_1", "treat_2"), prefix = "A_")

# Mask multiple sets separately
# Note that the order of masking matters
# Try to mix up the order of prefixes
# for different sets to ensure proper masking.
df |>
  mask_names(starts_with("treat_"), prefix = "B_") |>
  mask_names(starts_with("outcome_"), prefix = "A_")

# Example with the 'williams' dataset
data(williams)
set.seed(42)

williams |>
  mask_names(starts_with("SexUnres"), prefix = "A_") |>
  mask_names(starts_with("Impul"), prefix = "B_") |>
  colnames()

}
\seealso{
\code{\link{mask_labels}} for masking values in a vector,
\code{\link{mask_variables}} for masking values in multiple variables.
}
\keyword{mask}
