% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_srs.R
\name{var_srs}
\alias{var_srs}
\title{The estimation of the simple random sampling}
\usage{
var_srs(Y, w = rep(1, length(Y)))
}
\arguments{
\item{Y}{The variables of interest.}

\item{w}{Weight variable. One dimensional object convertible to one-column \code{data.frame}.}
}
\value{
A list with objects are returned by the function:
\itemize{
 \item \code{S2p} - a \code{data.table} containing the values of the variance estimation of the population.
 \item \code{varsrs} - a \code{data.table} containing the values of the variance estimation of the simple random sampling.
 }
}
\description{
Computes the estimation of the simple random sampling.
}
\examples{
Ys <- matrix(rchisq(10, 3), 10, 1)
ws <- c(rep(2, 5), rep(3, 5))
var_srs(Ys, ws)

}
\references{
Yves G. Berger, Tim Goedeme, Guillame Osier (2013). Handbook on standard error estimation and other related sampling issues in EU-SILC, URL \url{https://wayback.archive-it.org/12090/20231228140953/https://cros-legacy.ec.europa.eu/content/handbook-standard-error-estimation-and-other-related-sampling-issues-ver-29072013_en}
}
\seealso{
\code{\link{vardom}},
         \code{\link{vardomh}},
         \code{\link{varpoord}}
}
\keyword{variance}
