% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preparation.R
\name{validate_panel_data}
\alias{validate_panel_data}
\title{Validate Panel Data Structure}
\usage{
validate_panel_data(panel_data, require_log = TRUE)
}
\arguments{
\item{panel_data}{Data frame to validate.}

\item{require_log}{Logical. Check for log-transformed columns. Default TRUE.}
}
\value{
TRUE invisibly if valid, otherwise stops with informative error.
}
\description{
Checks that panel data has required columns and valid structure.
}
\examples{
set.seed(123)
panel <- data.frame(
  year = rep(2000:2002, 3),
  sector = rep(c("A", "B", "C"), each = 3),
  log_direct = rnorm(9),
  log_production = rnorm(9)
)
validate_panel_data(panel)

}
