% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UWaterloo.R
\docType{data}
\name{uwaterloo_math}
\alias{uwaterloo_math}
\title{Faculty of Math colors of the University of Waterloo, Canada}
\format{
An object of class \code{character} of length 4.
}
\source{
Color definitions are based on the University of Waterloo's 
\href{https://uwaterloo.ca/}{Brand home}.
}
\usage{
uwaterloo_math
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uwaterloo_math} provides the four pink color levels
of the \href{https://uwaterloo.ca}{University of Waterloo}, Canada.
}
\details{
Use the color Pink to identify content and communications from the Faculty of Math.

The 4 pink colors are 
\code{"Pink Level 1"} (defined as CMYK: 3 29 0 0, RGB:	255 190 239, HEX:	#FFBEEF),
\code{"Pink Level 2"} (defined as CMYK: 0 30 99 0, RGB: 251 175 0, HEX: #FBAF00),
\code{"Pink Level 3"} (print primary color) (defined as CMYK: 0 68 0 0, RGB: 255 99 170, HEX: #FF63AA), and
\code{"Pink Level 4"} (digital primary color) (defined as CMYK: 18 100 4 17, RGB:	198 0 120, HEX:	#C60078).


\code{uwaterloo_math} uses the HEX color definitions.
}
\examples{
uwaterloo_math
unikn::seecol(uwaterloo_math, main = "Math faculty colors of UWaterloo") 
# view color palette

}
\seealso{
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{concordia_1}},
\code{\link{concordia_2}},
\code{\link{concordia_3}},
\code{\link{concordia_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_1}},
\code{\link{uvic_2}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-06-29.
}
\concept{Canadian university color palettes}
\keyword{datasets}
