% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_wide2long}
\alias{umx_wide2long}
\title{umx_wide2long}
\usage{
umx_wide2long(
  data = df,
  timevar = list(condition = c("control", "expt")),
  repeated = list(example = c("easyexample", "hardexample"), grade = c("grd1", "grd2")),
  covs = c("Age", "Sex"),
  idvar = "PID",
  sep = "_T",
  verbose = FALSE
)
}
\arguments{
\item{data}{A data.frame to make long.}

\item{timevar}{A list of the conditions individuals are in that generate repeated measures, list(condition = c("control", "expt"))}

\item{repeated}{A list of varied inputs and their levels: i.e., list(exam = c("easy", "hard"), ...)}

\item{covs}{A vector of variables that do not vary, e.g., c("Age", "Sex", "IQ").}

\item{idvar}{The column containing the unique ID of the subjects "PID".}

\item{sep}{For twin data - calls = umx_wide2longTwinData default "_T"}

\item{verbose}{Whether to be verbose (FALSE)}
}
\value{
\itemize{
\item a long version of the df.
}
}
\description{
Makes wide data long using reshape
Hopefully a more robust interface to \code{\link[=reshape]{reshape()}}
For twin data, this calls \code{umx_wide2longTwinData(data =data, sep = sep, verbose = verbose)}
}
\details{
This is for processing data in which subjects (identified by a \code{idvar} column, have repeated measures on one or more outcomes.
The goal is to make the data into long format, for passing to functions like \code{\link[lme4:lmer]{lme4::lmer()}}.
You must:
\enumerate{
\item Set \code{timevar}. This is a list of the conditions that you repeated. The name becomes a column in the long output. e.g., \code{list(difficulty = c("easy", "hard"))}
\item Set \code{repeated} This is a list of the measured outcomes, e.g. \code{list(DV = c("NASA1_frust", "NASA2_frust"), effort = c("NASA1_eff", "NASA2_eff"))}
\item Set \code{covs} This is vector of non-repeated non-varying IVs c("age", "sex", "IQ").
}

Table: The resulting output is like this:\tabular{lcrr}{
   \strong{idvar} \tab \strong{condition} \tab \strong{Age} \tab \strong{DV} \cr
   001 \tab "easy" \tab 45 \tab 10 \cr
   001 \tab "hard" \tab 45 \tab 75 \cr
   002 \tab "easy" \tab 19 \tab 54 \cr
   002 \tab "hard" \tab 19 \tab 74 \cr
}
}
\examples{
\dontrun{
timevar  = list(difficulty = c("easy", "hard"))
repeated = list(
   frustration = c("NASA1_frustration", "NASA2_frustration"), 
   effort      = c("NASA1_effort", "NASA2_effort")
)
df.l = umx_long2wide(data, timevar, repeated, covs = c("Age"), idvar = "PID")
}
}
\seealso{
\itemize{
\item \code{\link[=reshape]{reshape()}}
}

Other Miscellaneous Utility Functions: 
\code{\link{install.OpenMx}()},
\code{\link{libs}()},
\code{\link{qm}()},
\code{\link{umx}},
\code{\link{umxLav2RAM}()},
\code{\link{umxModelNames}()},
\code{\link{umxRAM2Lav}()},
\code{\link{umxVersion}()},
\code{\link{umx_array_shift}()},
\code{\link{umx_find_object}()},
\code{\link{umx_lower.tri}()},
\code{\link{umx_msg}()},
\code{\link{umx_open_CRAN_page}()},
\code{\link{umx_pad}()},
\code{\link{umx_print}()},
\code{\link{umx_wide4lmer}()}
}
\concept{Miscellaneous Utility Functions}
