% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{txt_paste}
\alias{txt_paste}
\title{Concatenate strings with options how to handle missing data}
\usage{
txt_paste(..., collapse = " ", na.rm = FALSE)
}
\arguments{
\item{...}{character vectors}

\item{collapse}{a character string to be used to paste the vectors together. Defaults to a space: ' '.}

\item{na.rm}{logical, if set to \code{TRUE}, will replace NA with ''. If set to \code{FALSE}, will have a resulting value of NA
if at least one element is \code{NA}, in a similar spirit as \code{mean}. Defaults to \code{FALSE}.}
}
\value{
a character vector
}
\description{
NA friendly version for concatenating string
}
\examples{
x <- c(1, 2, 3, NA, NA)
y <- c("a", "b", "c", NA, "OK")
paste(x, y, sep = "-")
txt_paste(x, y, collapse = "-", na.rm = TRUE)
txt_paste(x, y, collapse = "-", na.rm = FALSE)

x <- c(NA, "a", "b")
y <- c("1", "2", NA)
z <- c("-", "*", NA)
txt_paste(x, y, z, collapse = "", na.rm = TRUE)
txt_paste(x, y, z, "_____", collapse = "", na.rm = TRUE)
txt_paste(x, y, z, "_____", collapse = "", na.rm = FALSE)
}
\seealso{
\code{\link{paste}}
}
