#' tseriesTARMA: Analysis of Nonlinear Time Series through Threshold Autoregressive Moving Average Models (TARMA) models
#'
#' It provides advanced functions for:
#' * TARMA model fitting and forecasting:
#'    - Least Squares fitting of a full subset TARMA model, including robust M estimation.
#'    - Maximum Likelihood fitting of a subset TARMA model with common MA parts and possible covariates.
#' * TARMA testing for threshold type nonlinearity:
#'    - Tests for AR vs TAR (asymptotic, bootstrap, wild bootstrap)
#'    - Tests for ARMA vs TARMA with both i.i.d. errors and GARCH errors.
#' * Unit-root testing against a stationary TARMA model
#'
#' @author Simone Giannerini, \email{simone.giannerini@@uniud.it}
#' @author Greta Goracci, \email{greta.goracci@@unibz.it}
#' @references
#' * \insertRef{Gor25}{tseriesTARMA}
#' * \insertRef{Gor23b}{tseriesTARMA}
#' * \insertRef{Gia23}{tseriesTARMA}
#' * \insertRef{Gia22}{tseriesTARMA}
#' * \insertRef{Ang25}{tseriesTARMA}
#' * \insertRef{Ang23}{tseriesTARMA}
#' * \insertRef{Gia21}{tseriesTARMA}
#' * \insertRef{Gor23}{tseriesTARMA}
#' * \insertRef{Gor21}{tseriesTARMA}
#' * \insertRef{Cha19}{tseriesTARMA}
#' * \insertRef{Cha24}{tseriesTARMA}
#' * \insertRef{Cha20}{tseriesTARMA}
#' 
#' @docType package
#' @name tseriesTARMA
#' @useDynLib tseriesTARMA
#' @importFrom Rdpack reprompt
#' @import mathjaxr
#' @keywords internal
"_PACKAGE"
NULL
#> NULL
