% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LmME.R
\name{vcov.LmME}
\alias{vcov.LmME}
\title{Get the variance-covariance matrix of the parameters of an LmME model}
\usage{
\method{vcov}{LmME}(
  object,
  as.lm = FALSE,
  parm = NULL,
  pargroup = c("all", "fixef", "ranef"),
  ...
)
}
\arguments{
\item{object}{A fitted \code{LmME} object.}

\item{as.lm}{If \code{TRUE}, return the covariance matrix of the same
parameterization as used by \code{\link[lme4]{lmer}}.}

\item{parm}{Names of the parameters to extract.}

\item{pargroup}{The name of the parameter group to extract. With \code{as.lm = FALSE},
the available options are described in \code{confint.tramME}. When \code{as.lm = TRUE},
the following options are available:
\itemize{
  \item all: Fixed effects and variance components parameters.
  \item fixef: Fixed effects parameters (including FE parameters of the smooth terms).
  \item ranef: Variance components parameters (including the smoothing parameters of
    the random effects).
}}

\item{...}{Optional parameters passed to \code{confint.tramME}}
}
\value{
A numeric covariance matrix.
}
\description{
Get the variance-covariance matrix of the parameters of an LmME model
}
\examples{
data("sleepstudy", package = "lme4")
fit <- LmME(Reaction ~ Days + (Days | Subject), data = sleepstudy)
vcov(fit) ## transformation model parameterization
vcov(fit, as.lm = TRUE) ## LMM parameterization
vcov(fit, as.lm = TRUE, pargroup = "fixef") ## cov of fixed effects
}
